package com.xdja.im.base.di.module;

import android.content.Context;

import com.google.gson.Gson;
import com.xdja.im.base.di.DiConfig;
import com.xdja.im.base.di.scope.Scoped;
import com.xdja.im.common.utils.CommonTool;

import javax.inject.Singleton;

import dagger.Module;
import dagger.Provides;

/**
 * @Package: com.xdja.im.base.di.module
 * @Author: xdjaxa
 * @Creation: 2017-04-12 14:41
 * @Version V1.0
 * @Description:
 */
@Module
public class UtilModule {

    @Singleton
    @Provides
    Gson provideGson(){
        return new Gson();
    }

    @Singleton
    @Provides
    CommonTool provideCommonTool(@Scoped(DiConfig.CONTEXT_SCOPE_APP) Context context) {
        return new CommonTool(context);
    }
}
