package com.xdja.im.common.imageloader;

import android.content.Context;

import com.bumptech.glide.Glide;
import com.bumptech.glide.GlideBuilder;
import com.bumptech.glide.load.engine.bitmap_recycle.LruBitmapPool;
import com.bumptech.glide.load.engine.cache.DiskLruCacheFactory;
import com.bumptech.glide.load.engine.cache.LruResourceCache;
import com.bumptech.glide.load.engine.cache.MemorySizeCalculator;
import com.bumptech.glide.module.GlideModule;
import com.xdja.im.common.utils.CachePath;

import java.io.File;

/**
 * @Package: com.xdja.im.common.imageloader
 * @Author: xdjaxa
 * @Creation: 2017-05-23 8:54
 * @Version V1.0
 * @Description:自定义Glide缓存模块
 */
public class CustomCacheGlideModule implements GlideModule {

    @Override
    public void applyOptions(Context context, GlideBuilder glideBuilder) {
        MemorySizeCalculator calculator = new MemorySizeCalculator(context);
        int defaultMemoryCacheSize = calculator.getMemoryCacheSize();
        int defaultBitmapPoolSize = calculator.getBitmapPoolSize();

        int customMemoryCacheSize = (int) (1.2 * defaultMemoryCacheSize);
        int customBitmapPoolSize = (int) (1.2 * defaultBitmapPoolSize);

        glideBuilder.setMemoryCache(new LruResourceCache(customMemoryCacheSize));
        glideBuilder.setBitmapPool(new LruBitmapPool(customBitmapPoolSize));

        //设置磁盘缓存目录
        String downloadDirectoryPath = context.getCacheDir().getParent() +
                File.separator +
                CachePath.ROOT_KIT_PATH +
                File.separator +
                CachePath.PARENT_CACHE_PATH +
                File.separator +
                CachePath.PARENT_IMAGE_PATH;
        //设置缓存大小800M
        int diskCacheSize = 800 * 1024 * 1024;
        glideBuilder.setDiskCache(new DiskLruCacheFactory(downloadDirectoryPath, diskCacheSize));
    }

    @Override
    public void registerComponents(Context context, Glide glide) {

    }
}
