package com.xdja.im.common.imageloader;

import android.app.Activity;
import android.content.Context;
import android.widget.ImageView;

import com.xdja.im.uikit.ImUiKit;

import javax.inject.Inject;

/**
 * @Package: com.xdja.im.common.imageloader
 * @Author: xdjaxa
 * @Creation: 2017-04-25 15:40
 * @Version V1.0
 * @Description: 默认图片加载器
 */
public class DefaultImageLoader implements ImageLoader{

    private Context sContext;

    /**
     * 缓存大小
     */
    public static final long MAX_CACHE_SIZE = 200 * 1024 * 1024;

    /**
     * 缓存文件名称
     */
    public static final String CACHE_NAME = "image_manager_disk_cache";

    @Inject
    public DefaultImageLoader() {
        sContext = ImUiKit.getInstance().getContext();
        /*ImageLoaderConfiguration config = new ImageLoaderConfiguration.Builder(sContext)
                //.memoryCacheExtraOptions(480, 800) // max width, max height，即保存的每个缓存文件的最大长宽
                .threadPriority(Thread.MAX_PRIORITY)
                .denyCacheImageMultipleSizesInMemory()
                //.diskCacheSize(50 * 1024 * 1024) //最大缓存文件大小
                //.memoryCache(new LruMemoryCache(50 * 1024 * 1024))//内存缓存大小
                .diskCacheFileNameGenerator(new Md5FileNameGenerator())
                .tasksProcessingOrder(QueueProcessingType.LIFO)
                .diskCache(getDiskCache(sContext))   //自定义缓存路径
                .defaultDisplayImageOptions(getOptions())//DisplayImageOptions.createSimple()
                .build();
        com.nostra13.universalimageloader.core.ImageLoader.getInstance().init(config);*/
    }

    /*private LruDiskCache getDiskCache(Context context) {
        try {
            UiKitOptions options = UiKitOptions.getOptions();

            File cacheDir;
            if (!TextUtils.isEmpty(options.cacheDir)) {
                cacheDir = new File(options.cacheDir, CACHE_NAME);
            } else {
                cacheDir = new File(context.getCacheDir(), CACHE_NAME);
            }

            return new LruDiskCache(cacheDir, new Md5FileNameGenerator(), MAX_CACHE_SIZE);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    */

    /**
     * 获取配置信息
     *
     * @return 配置信息
     *//*
    private DisplayImageOptions getOptions() {
        DisplayImageOptions options = new DisplayImageOptions.Builder()//
                .showImageOnLoading(R.mipmap.im_uikit_pic_default)         //设置图片在下载期间显示的图片
                .showImageForEmptyUri(R.mipmap.im_uikit_pic_default)       //设置图片Uri为空或是错误的时候显示的图片
                .showImageOnFail(R.mipmap.im_uikit_pic_failed)             //设置图片加载/解码过程中错误时候显示的图片
                .cacheInMemory(true)                              //设置下载的图片是否缓存在内存中
                .cacheOnDisk(true)                                //设置下载的图片是否缓存在SD卡中
                .build();
        return options;
    }
*/
    @Override
    public void loadImage(Activity activity, ImageView target, String path, ImageView.ScaleType type, int width, int height) {
        /* ImageSize imageSize = new ImageSize(width, height);
        com.nostra13.universalimageloader.core.ImageLoader.getInstance().displayImage(
                Uri.parse("file://" + path).toString(), target, imageSize
        );*/
    }

    @Override
    public void clearMemoryCache(Activity activity) {
        CustomImageLoader.getInstance().clearCache();
    }
}
