package com.xdja.im.core.model.event;

import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.TalkSessionBean;
import com.xdja.im.lib.file.bean.FileItem;

/**
 * @Package: com.xdja.im.core.model.event
 * @Author: xdjaxa
 * @Creation: 2017-04-17 11:04
 * @Version V1.0
 * @Description:OttO事件定义
 */
public class IMProxyEvent {

    /**
     * SDK初始化完成事件
     */
    public static class OnInitFinishedEvent {
        @Override
        public String toString() {
            return "OnInitFinishedEvent";
        }
    }

    public static class OnInitFailedEvent {
        @Override
        public String toString() {
            return "OnInitFailedEvent";
        }
    }

    /**
     * 已选文件事件
     */
    public static class FileSelectedEvent {
        FileItem fileInfo;

        public FileSelectedEvent(FileItem fileInfo) {
            this.fileInfo = fileInfo;
        }

        public FileItem getFileInfo() {
            return fileInfo;
        }

        public void setFileInfo(FileItem fileInfo) {
            this.fileInfo = fileInfo;
        }
    }

    /**
     * 已选文件事件
     */
    public static class FileUpdateEvent {

        public FileUpdateEvent() {
        }
    }

    /**
     * 聊天文件事件
     */
    public static class FileChatUpdateEvent {

        public FileChatUpdateEvent() {
        }
    }

    /**
     * 系统时间发生变化
     */
    public static class DataTimeChangedEvent {
    }

    /**
     * 网络状态上报
     */
    public static class NetworkStateEvent{
        private int state;

        public int getState() {
            return state;
        }

        public void setState(int state) {
            this.state = state;
        }
    }


    /**
     * 撤回成功的事件
     */
    public static class RecallMessageEvent {
        //撤回的会话信息
        private TalkSessionBean talkListBean;
        //撤回的单条消息
        private TalkMessageBean talkMessageBean;

        public TalkSessionBean getTalkSessionBean() {
            return talkListBean;
        }

        public void setTalkSessionBean(TalkSessionBean talkListBean) {
            this.talkListBean = talkListBean;
        }

        public TalkMessageBean getTalkMessageBean() {
            return talkMessageBean;
        }

        public void setTalkMessageBeans(TalkMessageBean talkMessageBean) {
            this.talkMessageBean = talkMessageBean;
        }
    }
    /**
     * 撤回失败的事件
     */
    public static class RecallFailEvent extends IMProxyMessageEvent.MessageEvent {
        //撤回的会话信息
        private TalkSessionBean talkListBean;
        //撤回失败的原因
        private int failCode;

        public int getFailCode() {
            return failCode;
        }

        public void setFailCode(int failCode) {
            this.failCode = failCode;
        }

        public TalkSessionBean getTalkSessionBean() {
            return talkListBean;
        }

        public void setTalkSessionBean(TalkSessionBean talkListBean) {
            this.talkListBean = talkListBean;
        }
    }
}
