package com.xdja.im.core.repository.interf.datasource;

import android.support.annotation.NonNull;

import com.xdja.im.uikit.entity.NoDisturbConfig;
import com.xdja.im.uikit.entity.SettingTopConfig;

import java.util.List;

import rx.Observable;
import rx.Subscriber;

/**
 * @Package: com.xdja.im.core.repository.impl.datasource
 * @Author: xdjaxa
 * @Creation: 2017-04-11 13:58
 * @Version V1.0
 * @Description:网络存储接口定义
 */
public interface CloudDataStore {

    /**
     * 推送标识上报
     *
     * @param appId      应用标识
     * @param subscriber
     */
    void reportPushClientId(String appId, Subscriber<Boolean> subscriber);

    /**
     * 开启或关闭置顶模式  云端数据
     *
     * @param sessionId 会话id
     */
    void setCloudSessionTop(String sessionId, Subscriber<Boolean> subscriber);

    /**
     * 从云端删除指定的置顶模式设置
     * @param sessionId 会话id
     * @return 删除结果
     */
    void deleteSettingTopAtCloud(String sessionId, Subscriber<Boolean> subscriber);

    /**
     * 从云端查询置顶模式设置
     * @param account 帐号
     * @return 获取到的勿扰模式设置
     */

    Observable<List<SettingTopConfig>> getSettingTopSettingsAtCloud(@NonNull String account);

    /**
     * 保存勿扰模式设置到云端
     * @param  sessionFlag 会话id 勿扰模式设置
     * @return  保存结果
     */
    void saveNoDisturb2Cloud(String sessionFlag,String talkerAccount,int sessionType,Subscriber<Boolean> subscriber);

    /**
     * 从云端删除指定的勿扰模式设置
     * @param  sessionFlag 会话id 勿扰模式设置
     * @return 删除结果
     */
    void deleteNoDisturbAtCloud(String sessionFlag, String talkerAccount,int sessionType,Subscriber<Boolean> subscriber);

    /**
     * 从云端查询勿扰模式设置
     * @param account 帐号
     * @return 获取到的勿扰模式设置
     */
    Observable<List<NoDisturbConfig>> getNoDisturbSettingsAtCloud(@NonNull String account);
}
