package com.xdja.im.core.repository.interf.datasource;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.xdja.im.core.model.param.SessionParam;
import com.xdja.im.core.model.param.SettingParam;
import com.xdja.im.uikit.entity.KeyValuePair;

import java.util.List;

import rx.Observable;
import rx.Subscriber;

/**
 * @Package: com.xdja.im.core.repository.impl.datasource
 * @Author: xdjaxa
 * @Creation: 2017-04-11 13:59
 * @Version V1.0
 * @Description:硬盘存储接口定义
 */
public interface DiskDataStore {

    /**
     * 开启或关闭置顶模式
     *
     * @param sessionFlag 会话标识
     * @param isTop       true:置顶会话  false 取消置顶
     * @param subscriber
     */
    void setSessionTop(String sessionFlag, boolean isTop, Subscriber<Boolean> subscriber);

    /**
     * 开启或关闭免打扰模式
     *
     * @param sessionFlag
     * @param isDisturb
     * @param subscriber
     */
    void setSessionDisturb(String sessionFlag, boolean isDisturb, Subscriber<Boolean> subscriber);

    /**
     * 开启或关闭听筒模式
     *
     * @param sessionFlag
     * @param isOpen
     * @param subscriber
     */
    void setReceiveMode(String sessionFlag, boolean isOpen, Subscriber<Boolean> subscriber);

    /**
     * 保存草稿信息
     *
     * @param sessionFlag
     * @param content
     */
    void saveDraftContent(String sessionFlag, String content, long draftTime, Subscriber<Boolean> subscriber);

    /**
     * 清除草稿信息
     *
     * @param sessionFlag
     * @param subscriber
     */
    void clearDraftContent(String sessionFlag, long draftTime, Subscriber<Boolean> subscriber);

    /**
     * 获取草稿信息
     *
     * @param sessionFlag
     * @param subscriber
     */
    void getDraftContent(String sessionFlag, Subscriber<String> subscriber);

    /**
     * 加载会话对应的配置信息
     *
     * @param sessionFlag
     * @param subscriber
     */
    void loadSessionParam(String sessionFlag, Subscriber<SessionParam> subscriber);

    /**
     * 加载所有的会话配置信息
     *
     * @param subscriber
     */
    void loadAllSessionParams(Subscriber<List<SessionParam>> subscriber);

    /**
     * 将所有回话设置，保存到本地
     * @param configs 回话配置对象
     * @return 回话配置对象
     */
    Observable<List<SessionParam>> saveSettingTopAndNodisturb2Local(List<SessionParam> configs);

    /**
     * 删除会话配置信息
     *
     * @param sessionFlag
     */
    void deleteSessionParam(String sessionFlag, Subscriber<Boolean> subscriber);

    /**
     * 删除所有会话消息
     *
     * @param subscriber
     */
    void deleteAllSessionParams(Subscriber<Boolean> subscriber);

    /**
     * 保存用户设置
     *
     * @param settings 待保存的用户设置
     * @return 保存结果
     */
    Observable<Boolean> saveIntKeyValuePairs(@NonNull KeyValuePair<String, Integer> settings);

    /**
     * 从本地查询整型持久化数据
     *
     * @param key 目标键
     * @return 目标值
     */
    Observable<Boolean> queryIntegerSharePref(@Nullable String key);

    //***************************************************************
    //***********************以下接口保存IM设置信息**********************
    //***************************************************************

    /**
     * 获取IM设置信息
     *
     * @param subscriber
     */
    void loadSettingParams(Subscriber<SettingParam> subscriber);
}
