package com.xdja.im.core.utils;

import android.util.LruCache;

/**
 * @Package: com.xdja.im.uikit.utils
 * @Author: xdjaxa
 * @Creation: 2017-07-20 11:13
 * @Version V1.0
 * @Description:
 */
public class DataCache {

    private LruCache<String, Object> mCache;

    private DataCache() {
        // use 1/8 of available heap size
        mCache = new LruCache<>((int) (Runtime.getRuntime().maxMemory() / 8));
    }

    private static class SingletonInstance{
        private static final DataCache mInstance = new DataCache();
    }

    public static DataCache getInstance() {
        return SingletonInstance.mInstance;
    }

    public Object put(String key, Object value) {
        return mCache.put(key, value);
    }

    public Object get(String key) {
        return mCache.get(key);
    }

    public void remove(String key) {
        if (mCache != null) {
            mCache.remove(key);
        }
    }

    public void clearAll() {
        if (mCache != null) {
            mCache.evictAll();
        }
    }
}
