package com.xdja.im.lib.action.adapter;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;

import com.xdja.im.lib.action.bean.OptionBean;
import com.xdja.im.uikit.R;

import java.util.List;

/**
 * @Package:com.xdja.im.uikit.view.chatdetail.adapter
 * @Author:Lei
 * @Creation:2017-04-23 09:19
 * @Version 1.0
 * @Description:聊天菜单适配器
 */
public class ActionMenuAdapter extends BaseAdapter {

    private Context mContext;

    private List<OptionBean> mOptions;

    public ActionMenuAdapter(Context context, List<OptionBean> options) {
        this.mContext = context;
        this.mOptions = options;
    }

    @Override
    public int getCount() {
        return mOptions == null ? 0 : mOptions.size();
    }

    @Override
    public Object getItem(int position) {
        return mOptions.get(position);
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder viewHolder;
        if (convertView == null) {
            convertView = View.inflate(mContext, R.layout.im_uikit_item_chat_action_menu, null);
            viewHolder = new ViewHolder(convertView);
            convertView.setTag(viewHolder);
        } else {
            viewHolder = (ViewHolder) convertView.getTag();
        }

        viewHolder.bindData(mOptions.get(position));
        return convertView;
    }

    class ViewHolder {
        private ImageView iconImg;
        private TextView menuNameTv;

        public ViewHolder(View itemView) {
            iconImg = (ImageView) itemView.findViewById(R.id.img_chat_menu);
            menuNameTv = (TextView) itemView.findViewById(R.id.tv_chat_menu);
        }

        public void bindData(OptionBean bean) {
            iconImg.setImageResource(getImgRes(bean.getIcon()));
            menuNameTv.setText(getMenuName(bean.getLabel()));
        }
    }

    /**
     * 获取图标资源ID
     *
     * @param resOps
     * @return
     */
    public int getImgRes(String resOps) {
        if (TextUtils.isEmpty(resOps)) {
            return -1;
        }
        String type = resOps.substring(resOps.indexOf(".") + 1,
                resOps.lastIndexOf("."));
        String name = resOps.substring(resOps.lastIndexOf(".") + 1);
        switch (type) {
            case "drawable":
                return mContext.getResources().getIdentifier(name, "drawable", mContext.getPackageName());
            case "mipmap":
                return mContext.getResources().getIdentifier(name, "mipmap", mContext.getPackageName());
        }
        return -1;
    }

    /**
     * 获取字符串资源ID
     *
     * @param resOps
     * @return
     */
    public int getMenuName(String resOps) {
        String name = resOps.substring(resOps.lastIndexOf(".") + 1);
        return mContext.getResources().getIdentifier(name, "string", mContext.getPackageName());
    }
}
