package com.xdja.im.lib.action.uitls;

import android.content.Context;

import com.xdja.im.lib.action.bean.OptionBean;

import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

/**
 * @Package: com.xdja.im.lib.action.uitls
 * @Author: xdjaxa
 * @Creation: 2017-07-04 7:56
 * @Version V1.0
 * @Description:
 */
public class OptionParser {

    /**
     * 配置文件路径
     */
    public static final String OPTION_PATH = "options/chatOptions.xml";

    /**
     * 父标签名称
     */
    public static final String TAG_OPTION= "option";
    public static final String TAG_PARAM = "param";

    /**
     * 子标签名称
     */
    public static final String TAG_NAME = "name";
    public static final String TAG_ID = "id";
    public static final String TAG_TYPE = "type";
    public static final String TAG_PACKAGE = "package";
    public static final String TAG_CLASS = "class";
    public static final String TAG_CODE = "code";
    public static final String TAG_LABEL = "label";
    public static final String TAG_ICON = "icon";

    public static List<OptionBean> getOptions(Context context) throws Exception {
        InputStream inputStream = context.getAssets().open(OPTION_PATH);
        return parse(inputStream);
    }

    /**
     * 解析配置文件信息
     *
     * @param inputStream
     * @return
     * @throws Exception
     */
    public static List<OptionBean> parse(InputStream inputStream) throws Exception {
        //创建SAXParserFactory解析工厂类
        SAXParserFactory factory = SAXParserFactory.newInstance();
        //实例化一个SAXParser解析类
        SAXParser saxParser = factory.newSAXParser();
        XMLReader reader = saxParser.getXMLReader();
        ParseHandler parseHandler = new ParseHandler();
        reader.setContentHandler(parseHandler);
        reader.parse(new InputSource(inputStream));
        return parseHandler.getOptionList();
    }

    public static class ParseHandler extends DefaultHandler {

        private List<OptionBean> options;

        /**
         * 当前解析的Option
         */
        private OptionBean optionBean;

        /**
         * 当前标签名称
         */
        private String curTagName = null;

        public ParseHandler() {
        }

        public List<OptionBean> getOptionList() {

            return options;
        }

        /**
         * 开始解析文档，做初始化工作
         *
         * @throws SAXException
         */
        @Override
        public void startDocument() throws SAXException {
            super.startDocument();
            options = new ArrayList<>();
        }

        /**
         * 开始解析元素
         *
         * @throws SAXException
         */
        @Override
        public void startElement(String uri, String localName, String qName,
                                 Attributes attributes) throws SAXException {
            super.startElement(uri, localName, qName, attributes);
            if (TAG_OPTION.equals(localName)) {
                optionBean = new OptionBean();

                int size = attributes.getLength();
                for (int i = 0; i < size; i++) {
                    String attribute = attributes.getLocalName(i);
                    String value = attributes.getValue(i);
                    if (TAG_NAME.equals(attribute)) {
                        optionBean.setOption(value);
                    } else if (TAG_ID.equals(attribute)) {
                        optionBean.setId(Integer.parseInt(value));
                    } else if (TAG_TYPE.equals(attribute)) {
                        optionBean.setType(Integer.parseInt(value));
                    }
                }
            } else if (TAG_PARAM.equals(localName)) {
                Map<String, String> param = new HashMap<>();
                int size = attributes.getLength();
                for (int i = 0; i < size; i++) {
                    String attribute = attributes.getLocalName(i);
                    String value = attributes.getValue(i);
                    param.put(attribute, value);
                }
                optionBean.setParam(param);
            }
            curTagName = localName;
        }

        /**
         * 解析字符
         *
         * @throws SAXException
         */
        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            super.characters(ch, start, length);
            String value = new String(ch, start, length).trim();
            if (value != null && !"".equals(value) && !"\n".equals(value)) {
                switch (curTagName) {
                    case TAG_PACKAGE:
                        optionBean.setPkgName(value);
                        break;
                    case TAG_CLASS:
                        optionBean.setClsName(value);
                        break;
                    case TAG_CODE:
                        optionBean.setRequestCode(Integer.parseInt(value));
                        break;
                    case TAG_LABEL:
                        optionBean.setLabel(value);
                        break;
                    case TAG_ICON:
                        optionBean.setIcon(value);
                        break;
                }
            }
        }

        /**
         * 元素结束
         *
         * @throws SAXException
         */
        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            super.endElement(uri, localName, qName);
            if ("option".equals(localName)) {
                options.add(optionBean);
                optionBean = null;
            }
            curTagName = null;
        }

        /**
         * 文档结束
         *
         * @throws SAXException
         */
        @Override
        public void endDocument() throws SAXException {
            super.endDocument();
        }
    }
}
