package com.xdja.im.lib.file.bean;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * Created by xdjaxa on 2017/4/26.
 */
public class FileItem implements Parcelable {

    /** 文件名称*/
    private String fileName;
    /** 文件路径*/
    private String filePath;
    /** 文件大小*/
    private long fileSize;
    /** 文件类型**/
    private int fileType;
    /** 文件最后修改日期**/
    private long modifiedDate;
    /** 扩展信息，可为空*/
    private String extraInfo;
    /** 文件状态*/
    private boolean isSelected;

    private long duration;

    public FileItem() {
    }

    public FileItem(String fileName, String filePath, long fileSize, long modifiedDate, int fileType) {
        this.fileName = fileName;
        this.filePath = filePath;
        this.fileSize = fileSize;
        this.modifiedDate = modifiedDate;
        this.fileType = fileType;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFilePath() {
        return filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public long getFileSize() {
        return fileSize;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public int getFileType() {
        return fileType;
    }

    public void setFileType(int fileType) {
        this.fileType = fileType;
    }

    public long getModifiedDate() {
        return modifiedDate;
    }

    public void setModifiedDate(long modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    public String getExtraInfo() {
        return extraInfo;
    }

    public void setExtraInfo(String extraInfo) {
        this.extraInfo = extraInfo;
    }

    public boolean isSelected() {
        return isSelected;
    }

    public void setSelected(boolean selected) {
        isSelected = selected;
    }

    public long getDuration() {
        return duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        FileItem fileInfo = (FileItem) o;

        if (getFileSize() != fileInfo.getFileSize()) return false;
        if (getFileType() != fileInfo.getFileType()) return false;
        return !(getFilePath() != null ? !getFilePath().equals(fileInfo.getFilePath()) : fileInfo.getFilePath() != null);

    }

    @Override
    public int hashCode() {
        int result = getFilePath() != null ? getFilePath().hashCode() : 0;
        result = 31 * result + (int) (getFileSize() ^ (getFileSize() >>> 32));
        result = 31 * result + getFileType();
        return result;
    }

    @Override
    public String toString() {
        return "FileItem{" +
                "fileName='" + fileName + '\'' +
                ", filePath='" + filePath + '\'' +
                ", fileSize=" + fileSize +
                ", fileType=" + fileType +
                ", modifiedDate=" + modifiedDate +
                ", extraInfo='" + extraInfo + '\'' +
                ", isSelected=" + isSelected +
                '}';
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.fileName);
        dest.writeString(this.filePath);
        dest.writeLong(this.fileSize);
        dest.writeInt(this.fileType);
        dest.writeLong(this.modifiedDate);
        dest.writeString(this.extraInfo);
        dest.writeByte(this.isSelected ? (byte) 1 : (byte) 0);
        dest.writeLong(this.duration);
    }

    protected FileItem(Parcel in) {
        this.fileName = in.readString();
        this.filePath = in.readString();
        this.fileSize = in.readLong();
        this.fileType = in.readInt();
        this.modifiedDate = in.readLong();
        this.extraInfo = in.readString();
        this.isSelected = in.readByte() != 0;
        this.duration = in.readLong();
    }

    public static final Creator<FileItem> CREATOR = new Creator<FileItem>() {
        @Override
        public FileItem createFromParcel(Parcel source) {
            return new FileItem(source);
        }

        @Override
        public FileItem[] newArray(int size) {
            return new FileItem[size];
        }
    };
}
