package com.xdja.im.lib.file.widget.recyclerview;

import java.util.HashMap;
import java.util.Map;

public class ItemViewDelegateManager<T> {
    private Map<Integer, ItemViewDelegate<T>> delegates = new HashMap<>();

    public int getItemViewDelegateCount() {
        return delegates.size();
    }

    public ItemViewDelegateManager<T> addDelegate(ItemViewDelegate<T> delegate) {
        int viewType = delegates.size();
        if (delegate != null) {
            delegates.put(viewType, delegate);
            viewType++;
        }

        return this;
    }

    public ItemViewDelegateManager<T> addDelegate(int viewType,
                                                  ItemViewDelegate<T> delegate) {
        if (delegates.get(viewType) == null) {
            delegates.put(viewType, delegate);
        }
        return this;
    }

    public int getItemViewType(T item, int position) {
        for (Map.Entry<Integer, ItemViewDelegate<T>> entry : delegates.entrySet()) {
            ItemViewDelegate<T> delegate = entry.getValue();
            if (delegate.isForViewType(item, position)) {
                return entry.getKey();
            }
        }
        throw new IllegalArgumentException("No Item to match!");
    }

    public void covert(ViewHolder viewHolder, T item, int position) {
        for (Map.Entry<Integer, ItemViewDelegate<T>> entry : delegates.entrySet()) {
            ItemViewDelegate<T> delegate = entry.getValue();
            if (delegate.isForViewType(item, position)) {
                delegate.covert(viewHolder, item, position);
                return;
            }
        }
        throw new IllegalArgumentException("No Item to convert!");
    }

    public ItemViewDelegate getItemViewDelegate(int viewType) {
        return delegates.get(viewType);
    }
}
