package com.xdja.im.lib.filemanage.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.xdja.im.lib.file.bean.FileItem;
import com.xdja.im.uikit.R;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>Author: leiliangliang   </br>
 * <p>Date: 2016/12/5 17:34   </br>
 * <p>Package: com.xdja.imp.presenter.adapter</br>
 * <p>Description:            </br>
 */
public class FileListAdapter extends BaseFileListAdapter<FileListViewHolder> {

    private Context mContext;

    private List<List<FileItem>> mLocalFiles = new ArrayList<>();

    public FileListAdapter(Context context, List<String> groupTitles) {
        super(groupTitles);
        this.mContext = context;
    }

    /**
     * 填充子列表数据，并进行更新
     *
     * @param localFiles 子类表数据
     */
    public void addLocalFiles(List<List<FileItem>> localFiles) {
        this.mLocalFiles = localFiles;
    }

    @Override
    public int getChildrenCount(int groupPosition) {
        return mLocalFiles == null ? 0 : mLocalFiles.get(groupPosition).size();
    }

    @Override
    public Object getChild(int groupPosition, int childPosition) {
        List<FileItem> fileInfos = mLocalFiles.get(groupPosition);
        if (fileInfos != null) {
            return fileInfos.get(childPosition);
        }
        return null;
    }

    @Override
    public FileListViewHolder onCreateChildViewHolder(ViewGroup parent, int viewType) {

        View convertView;
        if (viewType == TYPE_VERTICAL) {
            convertView = LayoutInflater.from(parent.getContext())
                    .inflate(R.layout.im_uikit_filelist_item_vertical, parent, false);
        } else {
            convertView = LayoutInflater.from(parent.getContext())
                    .inflate(R.layout.im_uikit_filelist_item_grid, parent, false);
        }
        return new FileListViewHolder(mContext, convertView);
    }

    @Override
    public void onBindChildViewHolder(FileListViewHolder holder, int groupPosition, int childPosition) {
        final FileItem fileInfo = (FileItem) getChild(groupPosition, childPosition);
        if (fileInfo != null) {
            holder.bindData(fileInfo);
        }
    }
}
