package com.xdja.im.lib.filemanage.model;


import com.xdja.im.core.model.message.TalkMessageBean;

import java.util.List;

public class GridItemBean<T> {

    private T value;

    private List<TalkMessageBean> childList;

    private boolean isExpand;

    public int getSize(){
        return 1 + (childList != null ? childList.size() : 0);
    }

    public T getValue() {
        return value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public List<TalkMessageBean> getChildList() {
        return childList;
    }

    public void setChildList(List<TalkMessageBean> childList) {
        this.childList = childList;
    }

    public boolean isExpand() {
        return isExpand;
    }

    public void setExpand(boolean expand) {
        isExpand = expand;
    }

    public boolean isLeaf(){
        return childList == null || childList.size() == 0;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        GridItemBean<?> that = (GridItemBean<?>) o;

        return !(getValue() != null ? !getValue().equals(that.getValue()) : that.getValue() != null);

    }

    @Override
    public int hashCode() {
        return getValue() != null ? getValue().hashCode() : 0;
    }
}
