package com.xdja.im.lib.filemanage.util;


import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.lib.filemanage.model.GridItemBean;
import com.xdja.im.lib.filemanage.model.HistoryFileCategory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class NodeUtils {

    public static List<GridItemBean> convertData(Map<HistoryFileCategory,List<TalkMessageBean>> dataMaps){
        List<GridItemBean> beans = new ArrayList<>();

        List<HistoryFileCategory> titles = new ArrayList<>(dataMaps.keySet());
        Collections.sort(titles);

        for(HistoryFileCategory title : titles) {
            List<TalkMessageBean> talkMsgs = new ArrayList<>(dataMaps.get(title));

            GridItemBean bean = new GridItemBean();
            bean.setValue(title);
            bean.setChildList(talkMsgs);
            bean.setExpand(false);
            beans.add(bean);
        }
        return beans;
    }
}
