package com.xdja.im.lib.filemanage.util;

import android.os.Environment;
import android.text.TextUtils;

import com.xdja.imsdk.util.FileSizeUtils;
import com.xdja.imsdk.util.FileUtils;
import com.xdja.imsdk.util.ToolUtils;

import java.io.File;

/**
 * 项目名称：ActomaV2            <br>
 * 类描述  ：工具类               <br>
 * 创建时间：2016/11/16 16:57    <br>
 * 修改记录：                    <br>
 *
 * @author liming@xdja.com    <br>
 * @version                   <br>
 */
public class ToolUtil {

    private static final String ANTONG_TAG = "10000";

    private static final String ANTONG_FLAG = "10000_100";
    /**
     * 获取会话标识
     * @param id 对方账号
     * @param type 会话类型
     * @return tag
     */
    public static String getSessionTag(String id, int type) {
        return ToolUtils.getSessionTag(id, type);
    }

    /**
     * 获取分隔符后的字符串
     * @param input input
     * @param separator separator
     * @return String
     */
    public static String getLastString(String input, String separator) {
        return ToolUtils.getLastString(input, separator);
    }

    /**
     * 读取指定路径文件大小
     * @param filePath filePath
     * @return long
     */
    public static long getFileSize(String filePath) {
        return FileSizeUtils.getFileSize(filePath);
    }

    /**
     * 获取应用T卡缓存根目录(/sdcard/Actoma+/)
     * @return String
     */
    public static String getAppParent() {
        return Environment.getExternalStorageDirectory().getAbsolutePath() +
                File.separator +
                "Actoma+" +
                File.separator;
    }

    /**
     * 语音存储目录
     * @return /sdcard/AppName/XdjaIm/.MD5(account)/Voice/random1/random2/
     */
    public static String getVoicePath() {
        return FileUtils.getVoicePath();
    }
	
	/**
     * 网页文件存储目录
     * @return /sdcard/AppName/XdjaIm/.MD5(account)/Web/random1/random2/
     */
    public static String getWebPath() {
        return FileUtils.getWebFilePath();
    }
	
    /**
     * 短视频存储目录
     * @return /sdcard/AppName/XdjaIm/.MD5(account)/Video/random1/random2/
     */
    public static String getVideoPath() {
        return FileUtils.getVideoPath();
    }

    //add by ycm for share function 20170207 [start]
    /**
     * 获取应用T卡缓存根目录(/sdcard/Actoma+/Share/)
     * @return String
     */
    public static String getShareDirectory() {
        return Environment.getExternalStorageDirectory().getAbsolutePath() +
                File.separator +
                "Actoma+" +
                File.separator +
                "Share" +
                File.separator;
    }
    //add by ycm for share function 20170207 [end]

    /**
     * 判断该条消息是否是安通+团队的消息
     * @param account
     * @return
     */
    public static boolean isActomaMessage(String account) {
        if (TextUtils.isEmpty(account)) return false;
        return account.equals(ANTONG_TAG);
    }

    /**
     * 获取安通+团队消息的标志
     */
    public static String getActomaAccount() {
        return ANTONG_TAG;
    }

    /**
     * 判断该条会话是不是安通+会话
     */
    public static boolean isActomaTalk(String flag) {
        if (TextUtils.isEmpty(flag)) return false;
        return flag.equals(ANTONG_FLAG);
    }

    /**
     * 获取安通+团队的会话标识
     */
    public static String getAntongFlag() {
        return ANTONG_FLAG;
    }
}
