package com.xdja.im.lib.historyfile.util;


import android.text.TextUtils;

import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.core.model.message.file.ImageFileInfo;
import com.xdja.im.core.model.message.file.VideoFileInfo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 该类用于会话中图片发送与接收相关的功能涉及到的图片的选择记录
 */
public class HistoryModeUtils {

    /**
     * 本地已选文件集合
     */
    private static final Map<Long, TalkMessageBean> mLocalFileInfo = new HashMap<>();

    private static class SingletonInstance {
        private static final HistoryModeUtils mInstance = new HistoryModeUtils();
    }

    private HistoryModeUtils() {
    }

    public static HistoryModeUtils getInstance() {
        return SingletonInstance.mInstance;
    }

    /**
     * 从缓存中获取文件实体类
     *
     * @param key
     * @return
     */
    private TalkMessageBean getFileFromCache(String key) {
        return mLocalFileInfo.get(key);
    }

    /**
     * 文件实体加入到已选缓存中
     *
     * @param key
     * @param fileInfo
     */
    public void putFileToSelectedCache(long key, TalkMessageBean fileInfo) {
        if (fileInfo != null) {
            mLocalFileInfo.put(key, fileInfo);
        }
    }

    /**
     * 从缓存中移除文件
     *
     * @param key
     */
    public void removeToSelectedCache(long key) {
        mLocalFileInfo.remove(key);
    }

    /**
     * 获取所有已选文件
     *
     * @return
     */
    public List<TalkMessageBean> getAllSelectFiles() {

        List<TalkMessageBean> fileInfoList = new ArrayList<>();
        for (long key : mLocalFileInfo.keySet()) {
            fileInfoList.add(mLocalFileInfo.get(key));
        }
        return fileInfoList;
    }

    public long getSelectRawFileSize() {
        long size = 0;
        List<TalkMessageBean> fileList = new ArrayList<>(mLocalFileInfo.values());
        for (TalkMessageBean bean : fileList) {
            FileInfo fileInfo = bean.getFileInfo();
            if(fileInfo instanceof ImageFileInfo){
                if(((ImageFileInfo) fileInfo).isOriginal()) {
                    size = size + ((ImageFileInfo) fileInfo).getRawFileInfo().getFileSize();
                } else {
                    if(TextUtils.equals("gif",fileInfo.getSuffix())){
                        size = size + ((ImageFileInfo) fileInfo).getGifFileInfo().getFileSize();
                    } else {
                        size = size + fileInfo.getFileSize();
                    }
                }
            } else if (fileInfo instanceof VideoFileInfo) {
                size = size + ((VideoFileInfo)fileInfo).getRawFileInfo().getFileSize();
            } else {
                size = size + fileInfo.getFileSize();
            }
        }
        return size;
    }

    /**
     * 获取已选文件的个数
     *
     * @return
     */
    public int getSelectedFileCount() {
        return mLocalFileInfo.size();
    }

    /**
     * 清除缓存等相关数据
     */
    public void clearCache() {
        mLocalFileInfo.clear();
    }

}
