package com.xdja.im.lib.share.presenter;

import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.core.model.message.file.ImageFileInfo;
import com.xdja.im.core.model.message.file.VideoFileInfo;
import java.util.List;

/**
 * Created by wenqi on 2018/3/6.
 *  分享功能以及对话框回掉接口
 */

public interface ShareDialogPresenter<T> {

    /**
     * 图片分享
     *
     * @param dataSource        分享至的会话
     * @param localPictureInfos 分享的图片信息list
     * @param messageContent    留言
     */
    void shareImages(List<T> dataSource, List<ImageFileInfo> localPictureInfos, String messageContent);

    /**
     * 图片分享
     *
     * @param dataSource     分享至的会话
     * @param text           分享的文本内容
     * @param messageContent 留言
     */
    void shareText(List<T> dataSource, String text, String messageContent);

    /**
     * 图片分享
     *
     * @param dataSource        转发至的会话
     * @param localPictureInfos 转发的图片信息list
     * @param messageContent    留言
     */
    void forwardImages(List<T> dataSource, List<ImageFileInfo> localPictureInfos, String messageContent, boolean isOriginal);

    /**
     * 图片分享
     *
     * @param dataSource     转发至的会话
     * @param text           转发的文本内容
     * @param messageContent 留言
     */
    void forwardText(List<T> dataSource, String text, String messageContent);

    /**
     * 文件转发
     * @param dataSource 会话
     * @param localPictureInfos 本地图片信息
     * @param messageContent 留言
     */
    void forwardFile(List<T> dataSource, List<FileInfo> localPictureInfos, String messageContent);

    /**
     * 文件分享
     * @param dataSource 会话
     * @param localPictureInfos 本地图片信息
     * @param messageContent 留言
     */
    void shareFile(List<T> dataSource, List<FileInfo> localPictureInfos, String messageContent);

    /**
     * 短视频分享
     *
     * @param dataSource        分享至的会话
     * @param localVideoInfos 分享的图片信息list
     * @param messageContent    留言
     */
    void shareVideos(List<T> dataSource, List<VideoFileInfo> localVideoInfos, String messageContent);

    /**
     * 短视频转发
     *
     * @param dataSource        转发至的会话
     * @param localVideoInfos 转发的图片信息list
     * @param messageContent    留言
     */
    void forwardVideos(List<T> dataSource, List<VideoFileInfo> localVideoInfos, String messageContent);

//    /**
//     * 网页分享
//     *
//     * @param dataSource        分享至的会话
//     * @param webPageInfos 		分享的图片信息list
//     * @param messageContent    留言
//     */
//    void shareWebs(List<T> dataSource, List<WebPageInfo> webPageInfos, String messageContent);
//
//    /**
//     * 网页转发
//     *
//     * @param dataSource        转发至的会话
//     * @param webPageInfos 		转发的网页信息list
//     * @param messageContent    留言
//     */
//    void forwardWebs(List<T> dataSource, List<WebPageInfo> webPageInfos, String messageContent);
}
