package com.xdja.im.lib.share.view;


import android.content.Context;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.app.AlertDialog;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.bumptech.glide.Glide;
import com.xdja.im.lib.file.bean.FileItem;
import com.xdja.im.lib.filemanage.util.IMFileUtils;
import com.xdja.im.lib.share.model.IntentBean;
import com.xdja.im.lib.share.model.ShareBean;
import com.xdja.im.lib.share.model.ShareSendBean;
import com.xdja.im.lib.share.presenter.ShareSessionListPresenter;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.view.CircleImageView;
import com.xdja.im.uikit.view.PastEditText;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by wenqi on 2018/3/6.
 * 分享dialog
 */

public class ShareDialog {

    private Context context;

    private TextView sharedialogtv;
    private CircleImageView sharedialogusericon;
    private TextView sharedialogusername;
    private LinearLayout sharedialogsingleuserlayout;
    private LinearLayout sharedialogmoreuserlayout;
    private ImageView sharedialogimageContent;
    private TextView sharedialogtextContent;
    private LinearLayout sharedialogcontentLayout;
    private PastEditText sharedialogmessageContent;
    private LinearLayout sharedialogeditLayout;
    private TextView sharedialogcancelbtn;
    private TextView sharedialogsendbtn;
    private LinearLayout sharedialogbuttonLayout;


    private AlertDialog alertDialog;
    private ShareSessionListPresenter shareSessionListPresenter;
    private List<ShareBean> list = new ArrayList<>();
    private IntentBean intentBean;
    private int type = -1;

//    public ShareDialog(@NonNull Context context, ShareSessionListPresenter shareSessionListPresenter) {
//        this.shareSessionListPresenter = shareSessionListPresenter;
//        init(context);
//    }

    public ShareDialog(@NonNull Context context, int type, ShareSessionListPresenter shareSessionListPresenter) {
        this.type = type;
        this.shareSessionListPresenter = shareSessionListPresenter;
        init(context);
    }


    private void init(Context context) {
        this.context = context;
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        alertDialog = builder.create();
        View view = LayoutInflater.from(context).inflate(R.layout.im_uikit_share_dialog_layout, null);
        this.sharedialogbuttonLayout = (LinearLayout) view.findViewById(R.id.share_dialog_buttonLayout);
        this.sharedialogsendbtn = (TextView) view.findViewById(R.id.share_dialog_send_btn);
        this.sharedialogcancelbtn = (TextView) view.findViewById(R.id.share_dialog_cancel_btn);
        this.sharedialogeditLayout = (LinearLayout) view.findViewById(R.id.share_dialog_edit_Layout);
        this.sharedialogmessageContent = (PastEditText) view.findViewById(R.id.share_dialog_messageContent);
        this.sharedialogcontentLayout = (LinearLayout) view.findViewById(R.id.share_dialog_contentLayout);
        this.sharedialogtextContent = (TextView) view.findViewById(R.id.share_dialog_textContent);
        this.sharedialogimageContent = (ImageView) view.findViewById(R.id.share_dialog_imageContent);
        this.sharedialogmoreuserlayout = (LinearLayout) view.findViewById(R.id.share_dialog_more_user_layout);
        this.sharedialogsingleuserlayout = (LinearLayout) view.findViewById(R.id.share_dialog_single_user_layout);
        this.sharedialogusername = (TextView) view.findViewById(R.id.share_dialog_user_name);
        this.sharedialogusericon = (CircleImageView) view.findViewById(R.id.share_dialog_user_icon);
        this.sharedialogtv = (TextView) view.findViewById(R.id.share_dialog_tv);
        alertDialog.setView(view);
        sharedialogsendbtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                shareSessionListPresenter.onDialogRequestSend(list, intentBean, sharedialogmessageContent.getText().toString());
                alertDialog.dismiss();
            }
        });
        sharedialogcancelbtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                shareSessionListPresenter.onDialogCancleSend();
                alertDialog.dismiss();
            }
        });

    }

    public void showSingleDialog(ShareBean shareBean, IntentBean intentBean) {
        list.clear();
        list.add(shareBean);
        this.intentBean = intentBean;
        if (shareBean != null) {
            Glide.with(context)
                    .load(shareBean.getAvatarUrl())
                    .error(R.mipmap.im_uikit_user_header_40dp)
                    .into(sharedialogusericon);
            sharedialogusername.setText(shareBean.getDisplayName());
        }
        if (intentBean != null) {
            if (!TextUtils.isEmpty(intentBean.getContent())) {
                sharedialogtextContent.setText(intentBean.getContent());
                sharedialogcontentLayout.setVisibility(View.VISIBLE);
                sharedialogtextContent.setVisibility(View.VISIBLE);
            }
            if (intentBean.getUriArrayList() != null && intentBean.getUriArrayList().size() == 1) {
                FileItem info = IMFileUtils.queryLocalFiles(context, Uri.parse(Uri.decode(intentBean.getUriArrayList().get(0))));
                sharedialogcontentLayout.setVisibility(View.VISIBLE);
                sharedialogimageContent.setVisibility(View.VISIBLE);
                Glide.with(context)
                        .load(info.getFilePath())
                        .into(sharedialogimageContent);

            }
        }
        alertDialog.show();
    }

    public void showMulitDialog(List<ShareBean> list, IntentBean intentBean) {
        this.list.clear();
        this.list.addAll(list);
        this.intentBean = intentBean;
        sharedialogsingleuserlayout.removeAllViews();
        for (ShareBean shareBean : list) {
            CircleImageView circleImageView = getCircleImageView();
            Glide.with(context)
                    .load(shareBean.getAvatarUrl())
                    .error(R.mipmap.im_uikit_user_header_40dp)
                    .into(circleImageView);
            sharedialogsingleuserlayout.addView(circleImageView);
        }

        if (intentBean != null) {
            if (!TextUtils.isEmpty(intentBean.getContent())) {
                sharedialogtextContent.setText(intentBean.getContent());
                sharedialogcontentLayout.setVisibility(View.VISIBLE);
                sharedialogtextContent.setVisibility(View.VISIBLE);
            }
            if (intentBean.getUriArrayList() != null && intentBean.getUriArrayList().size() == 1) {
                FileItem info = IMFileUtils.queryLocalFiles(context, Uri.parse(Uri.decode(intentBean.getUriArrayList().get(0))));
                sharedialogimageContent.setVisibility(View.VISIBLE);
                Glide.with(context)
                        .load(info.getFilePath())
                        .into(sharedialogimageContent);

            }
        }
        alertDialog.show();

    }


    private CircleImageView getCircleImageView() {
        return new CircleImageView(context);
    }

}
