package com.xdja.im.lib.share.view;

import android.content.DialogInterface;
import android.content.Intent;
import android.support.annotation.ColorRes;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.account.AccountBean;
import com.xdja.im.core.model.message.TalkSessionBean;
import com.xdja.im.core.proxy.IMUiKitProxyImpl;
import com.xdja.im.lib.filemanage.model.ShareInfo;
import com.xdja.im.lib.share.adapter.ShareSessionListAdapter;
import com.xdja.im.lib.share.model.IntentBean;
import com.xdja.im.lib.share.model.ShareBean;
import com.xdja.im.lib.share.presenter.ShareSessionListPresenter;
import com.xdja.im.lib.share.util.BeanUtils;
import com.xdja.im.lib.share.util.ShareUtils;
import com.xdja.im.lib.share.view.vu.ShareViewSessionListVu;
import com.xdja.im.uikit.ImUiKit;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.base.ImFragmentSuperView;

import java.util.List;

import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.android.schedulers.AndroidSchedulers;
import rx.functions.Func1;
import rx.internal.schedulers.NewThreadScheduler;
import rx.schedulers.Schedulers;

/**
 * Created by wenqi on 2018/3/1.
 * share ui view
 */

public class ShareViewSessionList extends ImFragmentSuperView<ShareSessionListPresenter> implements ShareViewSessionListVu {


    private RelativeLayout shareSearchLayout;

    private EditText shareSearch;

    private RelativeLayout shareCreateNewSession;

    private RelativeLayout shareLoadMoreContact;

    private RecyclerView shareSessionList;

    private ProgressBar shareSessionLoading;

    private TextView shareSessionEmpty;


    @Override
    protected int getLayoutRes() {
        return R.layout.share_view_session_list_layout;
    }

    @Override
    protected int getToolbarType() {
        return ToolbarDef.NAVIGATE_BACK;
    }

    @Override
    public void setToolBarVisibility(int visibility) {
        supportActionBar(visibility == View.VISIBLE);
    }

    @Override
    public void setToolBarAddVisibility(int visibility) {
        setToolBarAddVisible(visibility == View.VISIBLE);
    }

    @Override
    public void setProgressBarVisibility(int visibility) {
        shareSessionLoading.setVisibility(visibility);
    }

    /**
     * 无数据是否可见
     *
     * @param visibility
     */
    @Override
    public void setShareSessionEmptyVisibility(int visibility) {
        shareSessionEmpty.setVisibility(visibility);
    }

    @Override
    public void setTitle(String title) {
        if (isSupportActionBar()) {
            setToolBarTitle(title);
        }
    }

    @Override
    public void setTitleColor(@ColorRes int id) {
        if (isSupportActionBar()) {
            setToolBarTitleColor(id);
        }
    }

    @Override
    protected void injectView() {
        super.injectView();
        shareSearchLayout = (RelativeLayout) findViewById(R.id.share_search_layout);
        shareSearch = (EditText) findViewById(R.id.share_search);
        shareCreateNewSession = (RelativeLayout) findViewById(R.id.share_create_new_session);
        shareLoadMoreContact = (RelativeLayout) findViewById(R.id.share_load_more_contact);
        shareSessionList = (RecyclerView) findViewById(R.id.share_session_list);
        shareSessionLoading = (ProgressBar) findViewById(R.id.share_session_loading);
        shareSessionEmpty = (TextView) findViewById(R.id.share_session_empty);
    }

    @Override
    public void init(LayoutInflater inflater, ViewGroup container) {
        super.init(inflater, container);

        addSearchListener();
        setNavigateCallback(new onNavigateCallback() {
            @Override
            public void onBackClick() {
                //getActivity().finish();
            }

            @Override
            public void onAddClick() {

            }
        });
        shareCreateNewSession.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                getPresenter().onCreateSessionClick();
            }
        });

        shareLoadMoreContact.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                getPresenter().onMoreContactClick();
            }
        });
    }

    private void addSearchListener() {
        shareSearch.addTextChangedListener(new TextWatcher() {

            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {

            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {

            }

            @Override
            public void afterTextChanged(Editable s) {
                String str = shareSearch.getText().toString();
                if (!TextUtils.isEmpty(str)) {
                    getPresenter().onSearchChanged(str);
                }
            }
        });
    }

    /**
     * 添加适配器
     *
     * @param adapter 适配器
     */
    @Override
    public void setAdapter(ShareSessionListAdapter adapter) {
        shareSessionList.setLayoutManager(new LinearLayoutManager(getActivity()));
        shareSessionList.setAdapter(adapter);
    }

    /**
     * 会话列表选择分享或者转发
     *
     * @param intent          分享或转发intent
     * @param talkSessionBean 联系人数据
     */
    @Override
    public void showDialog(final Intent intent, final TalkSessionBean talkSessionBean) {

        AccountBean accountBean = null;
        String account = talkSessionBean.getTalkerAccount();
        if (talkSessionBean.getTalkType() == ConstDef.CHAT_TYPE_P2G) {
            accountBean = IMUiKitProxyImpl.getInstance().getAccount(account, ConstDef.CHAT_TYPE_P2G);
        } else
            accountBean = IMUiKitProxyImpl.getInstance().getAccount(account, ConstDef.CHAT_TYPE_P2P);

        ShareBean shareBean = BeanUtils.convertAccountBean(accountBean, talkSessionBean.getTalkType());
        IntentBean intentBean = ShareUtils.getIntentBean(intent);
        new ShareDialog(getActivity(), 0, getPresenter()).showSingleDialog(shareBean, intentBean);
    }

    /**
     * 会话列表选择分享多人或者转发
     *
     * @param intent 分享或转发intent
     * @param list   联系人数据
     */
    @Override
    public void showMultiContactDialog(Intent intent, List<ShareBean> list) {
        IntentBean intentBean = ShareUtils.getIntentBean(intent);
        if (list != null) {
            if (list.size() == 1) {
                new ShareDialog(getActivity(), 0, getPresenter()).showSingleDialog(list.get(0), intentBean);
            } else {
                new ShareDialog(getActivity(), 1, getPresenter()).showMulitDialog(list, intentBean);
            }
        }
    }

    /**
     * 分享完成对话框
     */
    @Override
    public void showSimpleDialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder(getActivity());
        builder.setTitle(getResources().getString(R.string.im_uikit_share_over_title));
        builder.setMessage(getResources().getString(R.string.im_uikit_share_over_msg) + getResources().getString(R.string.app_name) + getResources().getString(R.string.im_uikit_share_over_msg_t));
        builder.setCancelable(false);
        builder.setPositiveButton(getResources().getString(R.string.im_uikit_share_over_send), new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                getPresenter().onTipsDialogTrueClick();
                dialog.cancel();
            }
        });
        builder.setNegativeButton(getResources().getString(R.string.im_uikit_share_over_cancel), new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                getPresenter().onTipsDialogClick();
                dialog.cancel();
            }
        });
        builder.create().show();
    }


}
