package com.xdja.im.lib.share.view.vu;

import android.content.Intent;
import android.support.annotation.ColorRes;

import com.xdja.im.base.frame.view.FragmentBaseView;
import com.xdja.im.core.model.message.TalkSessionBean;
import com.xdja.im.lib.share.adapter.ShareSessionListAdapter;
import com.xdja.im.lib.share.model.ShareBean;
import com.xdja.im.lib.share.presenter.ShareSessionListPresenter;

import java.util.List;

import rx.Subscriber;

/**
 * Created by wenqi on 2018/3/1.
 *
 */

public interface ShareViewSessionListVu extends FragmentBaseView<ShareSessionListPresenter> {


    /**
     * 设置ToolBar是否可见
     *
     * @param visibility
     */
    void setToolBarVisibility(int visibility);

    /**
     * 设置Toolbar上add功能是否可用
     *
     * @param visibility
     */
    void setToolBarAddVisibility(int visibility);

    /**
     * 进度条是否可见
     *
     * @param visibility
     */
    void setProgressBarVisibility(int visibility);

    /**
     * 无数据是否可见
     *
     * @param visibility
     */
    void setShareSessionEmptyVisibility(int visibility);

    /**
     * 设置显示
     *
     * @param title
     */
    void setTitle(String title);
    /**
     * 设置title显示颜色
     *
     * @param id
     */
    void setTitleColor(@ColorRes int id);
    /**
     * 添加适配器
     *
     * @param adapter 适配器
     */
    void setAdapter(ShareSessionListAdapter adapter);

    /**
     *
     * 会话列表选择分享或者转发
     * @param intent 分享或转发intent
     * @param talkSessionBean 数据
     */
    void showDialog(Intent intent, TalkSessionBean talkSessionBean);

    /**
     *
     * 会话列表选择分享多人或者转发
     * @param intent 分享或转发intent
     * @param list 联系人数据
     */
    void showMultiContactDialog(Intent intent, List<ShareBean> list);

    /**
     * 分享完成对话框
     */
    void showSimpleDialog();
}
