package com.xdja.im.uikit;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;

import com.xdja.im.base.di.component.ApplicationComponent;
import com.xdja.im.base.di.component.DaggerApplicationComponent;
import com.xdja.im.base.di.component.DaggerRepositoryComponent;
import com.xdja.im.base.di.component.RepositoryComponent;
import com.xdja.im.base.di.module.ApplicationModule;
import com.xdja.im.base.di.module.CacheModule;
import com.xdja.im.base.di.module.DataStoreModule;
import com.xdja.im.base.di.module.RepositoryModule;
import com.xdja.im.common.cache.entity.CardEntity;
import com.xdja.im.common.cache.entity.UserEntity;
import com.xdja.im.common.database.DatabaseManager;
import com.xdja.im.common.imageloader.GlideImageLoader;
import com.xdja.im.common.imageloader.ImageLoader;
import com.xdja.im.core.callback.AccountCallback;
import com.xdja.im.core.callback.ClearSessionDataCallback;
import com.xdja.im.core.callback.CommonCallback;
import com.xdja.im.core.callback.NotificationCallback;
import com.xdja.im.core.callback.OnChatAt2GroupCallBack;
import com.xdja.im.core.callback.OnChatMeetCallBack;
import com.xdja.im.core.callback.OnChatSettingCallback;
import com.xdja.im.core.callback.OnChatUserInfoCallback;
import com.xdja.im.core.callback.OnShareOverCallback;
import com.xdja.im.core.callback.ShareSelectCallback;
import com.xdja.im.core.callback.UnReadMessageCallback;
import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.account.AccountAction;
import com.xdja.im.core.model.account.ActionDesc;
import com.xdja.im.core.model.account.GroupAction;
import com.xdja.im.core.model.custom.CustomMsgInfo;
import com.xdja.im.core.model.message.MeetInfo;
import com.xdja.im.core.model.message.TalkCustomBean;
import com.xdja.im.core.model.message.TalkNotifyBean;
import com.xdja.im.core.model.message.TalkSessionBean;
import com.xdja.im.core.model.param.SessionParam;
import com.xdja.im.core.proxy.IMModuleProxyImpl;
import com.xdja.im.core.proxy.IMUiKitProxyImpl;
import com.xdja.im.core.proxy.ImUiKitContactProxyImpl;
import com.xdja.im.core.push.PushControllerImp;
import com.xdja.im.lib.album.ImagePickerConfig;
import com.xdja.im.lib.album.ImagePickerManager;
import com.xdja.im.lib.camera.CameraManager;
import com.xdja.im.lib.filemanage.util.ToolUtil;
import com.xdja.im.lib.historyfile.ui.HistoryFileActivityPresenter;
import com.xdja.im.lib.share.model.ShareBean;
import com.xdja.im.uikit.notification.NotificationUtil;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.imsdk.model.IMMessage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import rx.Subscriber;

/**
 * @Package: com.xdja.im.uikit
 * @Author: xdjaxa
 * @Creation: 2017-04-13 9:51
 * @Version V1.0
 * @Description:
 */
public class ImUiKit implements IClient {

    private static Context sContext;

    private ApplicationComponent applicationComponent;

    private RepositoryComponent repositoryComponent;

    private ImageLoader mImageLoader;
    /**
     * 配置信息
     */
    private UiKitOptions sdkOptions;
    /**
     * 初始化参数信息
     */
    private UiKitParams sdkParams;
    /**
     * 当前用户
     */
    private String curAccount;

    private static ImUiKit imUiKit;

    private ImUiKit() {
    }

//    private static class SingletonInstance {
//        private static final ImUiKit mInstance = new ImUiKit();
//    }

    public static ImUiKit getInstance() {
        if (imUiKit == null) {
            imUiKit = new ImUiKit();
        }
        return imUiKit;
    }

    @Override
    public void init(Context context, @Nullable UiKitOptions options) {
        //log
        //LogUtil.init(false, "ImUiKit");
        //CrashHandler.getInstance().init(context);

        LogUtil.d("ImUiKit Init.");
        sContext = context.getApplicationContext();
        sdkOptions = options;

        //初始化组件
        initComponent();
        //图片选择界面初始化
        initImagePicker();
    }

    @Override
    public void init(Context context, @NonNull UiKitParams params, @Nullable UiKitOptions options) {

        //log
        //LogUtil.init(false, "ImUiKit");
        //CrashHandler.getInstance().init(context);
        LogUtil.d("ImUiKit Init.");

        if (params == null || params.getAccountBean() == null ||
                TextUtils.isEmpty(params.getAccountBean().getAccount())) {
            LogUtil.e("Init user account is null error!");
            return;
        }
        sContext = context.getApplicationContext();
        sdkOptions = options;
        sdkParams = params;
        curAccount = params.getAccountBean().getAccount();

        LogUtil.d("params:" + params.toString());
        //初始化组件
        initComponent();
        //保存数据
        initData();
        //PushSdk初始化
        initPushClient();
        //IM初始化
        initIMProxy();
        //数据库初始化
        initDatabases();
        //图片选择界面初始化
        initImagePicker();
    }

    @Override
    public void release(int flag) {

        LogUtil.d("ImUiKit release.");

        //IMSdk释放
        //缓存清理（本地需要清理的，内存缓存清理）
        DatabaseManager.getInstance().close();
        IMModuleProxyImpl.getInstance().releaseProxy();
        IMUiKitProxyImpl.getInstance().releaseProxy();
        if (flag == 1) {
            PushControllerImp.getInstance().releasePush();
        }
    }

    @Override
    public UiKitOptions getOptions() {
        return sdkOptions;
    }

    @Override
    public void sendNotifyTextMessage(String sessionId, int sessionType, TalkNotifyBean bean) {
        IMModuleProxyImpl.getInstance().sendNotifyMessage(sessionId, sessionType, bean);
    }

    @Override
    public void sendShareContact(int type,List<ShareBean> list) {
        IMModuleProxyImpl.getInstance().sendShareInfo(type,list);
    }

    @Override
    public void sendCustomTextMessage(String sessionId, int sessionType, TalkCustomBean bean) {
        IMModuleProxyImpl.getInstance().sendCustomTextMessage(sessionId, sessionType, bean);
    }

    @Override
    public void clearSessionData(String sessionId, int sessionType) {
        IMModuleProxyImpl.getInstance().clearSessionData(sessionId, sessionType);
    }

    @Override
    public void setClearSessionData(String sessionId, int sessionType, ClearSessionDataCallback callback) {
        IMModuleProxyImpl.getInstance().setClearSessionData(sessionId, sessionType,callback);
    }

    @Override
    public void clearAllSessionData() {
        IMModuleProxyImpl.getInstance().clearAllSessionData();
    }

    @Override
    public void clearAllCacheData() {
        IMModuleProxyImpl.getInstance().clearCacheData();
    }

    @Override
    public void setReceiveMode(String sessionId, int sessionType, boolean isOpen) {
        IMModuleProxyImpl.getInstance().setReceiveMode(sessionId, sessionType, isOpen);
    }

    @Override
    public void setNoDisturbMode(String sessionId, int sessionType, boolean isDisturb) {
        IMModuleProxyImpl.getInstance().setNoDisturbMode(sessionId, sessionType, isDisturb);
    }

    @Override
    public void setSessionTop(String sessionId, int sessionType, boolean isTop) {
        IMModuleProxyImpl.getInstance().setSessionTop(sessionId, sessionType, isTop);
    }

    @Override
    public SessionParam getSessionParam(String sessionId, int sessionType) {
        return IMModuleProxyImpl.getInstance().getSessionParam(sessionId, sessionType);
    }

    @Override
    public void notifyAccountChanged(String account, AccountAction action) {
        IMUiKitProxyImpl.getInstance().notifyAccountChanged(account, action);
    }

    @Override
    public void notifyGroupChanged(String groupId, GroupAction action, ActionDesc actionDesc) {
        ImUiKitContactProxyImpl.getInstance().notifyGroupChanged(groupId, action, actionDesc);
    }

    @Override
    public void registerAccountCallback(AccountCallback callback) {
        IMUiKitProxyImpl.getInstance().setAccountCallback(callback);
    }

    @Override
    public void registerNotificationCallback(NotificationCallback callback) {
        IMUiKitProxyImpl.getInstance().setNotificationCallback(callback);
    }

    @Override
    public void registerUnReadMessageCallback(UnReadMessageCallback callback) {
        IMUiKitProxyImpl.getInstance().setUnReadMessageCallback(callback);
    }

    @Override
    public void registerOpenChatSettingCallback(OnChatSettingCallback callback) {
        IMUiKitProxyImpl.getInstance().setOpenChatSettingCallback(callback);
    }

    @Override
    public void registerOpenChatUserInfoCallback(OnChatUserInfoCallback callback) {
        IMUiKitProxyImpl.getInstance().setOpenChatUserInfoCallback(callback);
    }

    @Override
    public void registerCommonCallback(CommonCallback callback) {
        IMUiKitProxyImpl.getInstance().setCommonCallback(callback);
    }

    @Override
    public void registerAddChtMeeting(OnChatMeetCallBack callBack) {
        IMUiKitProxyImpl.getInstance().setOnChatMeetCallBack(callBack);
    }

    /**
     * 分享操作回掉
     *
     * @param callback
     */
    @Override
    public void registerShareSelectCallback(ShareSelectCallback callback) {
        IMUiKitProxyImpl.getInstance().setShareSelectCallback(callback);
    }

    @Override
    public void registerOnShareOverCallback(OnShareOverCallback callback){
        IMUiKitProxyImpl.getInstance().registerOnShareOverCallback(callback);
    }

    /**
     * 会话数据集合
     */
    private List<TalkSessionBean> mSessionList = new ArrayList<>();

    @Override
    public void registerInitUnReadMsgCallBack() {
        getComponent().proxyRepository().getSessionListBeans("",0, ConstDef.CHAT_TYPE_DEFAULT, new Subscriber<List<TalkSessionBean>>() {
            @Override
            public void onCompleted() {

            }

            @Override
            public void onError(Throwable e) {

            }

            @Override
            public void onNext(final List<TalkSessionBean> sessionBeanList) {
                getComponent().userOperateRepository().getAllSessionParams(new Subscriber<List<SessionParam>>() {
                    @Override
                    public void onCompleted() {

                    }

                    @Override
                    public void onError(Throwable e) {

                    }

                    @Override
                    public void onNext(List<SessionParam> sessionParams) {
                        if (sessionParams == null || sessionParams.isEmpty()) {
                            //剔除重复的会话
                            mSessionList.clear();
                            Iterator<TalkSessionBean> iterator = sessionBeanList.iterator();
                            for (; iterator.hasNext(); ) {
                                TalkSessionBean bean = iterator.next();

                                int index = sessionBeanList.indexOf(bean);
                                if (index > -1 && bean != sessionBeanList.get(index)) {
                                    iterator.remove();
                                }
                            }
                            mSessionList.addAll(sessionBeanList);

                            int unReadCount = 0;
                            for (TalkSessionBean bean : sessionBeanList) {
                                unReadCount += bean.getNotReadCount();//未读消息处理
                                SessionParam param = bean.getParam();
                                if (null != param && param.isDisturb()) {
                                    unReadCount -= bean.getNotReadCount();
                                }
                                IMUiKitProxyImpl.getInstance().updateUnReadMessageCount(unReadCount);
                            }
                            return;
                        }

                        for (int i = 0; i < sessionParams.size(); i++) {
                            SessionParam param = sessionParams.get(i);
                            TalkSessionBean tempBean = new TalkSessionBean();
                            tempBean.setTalkFlag(param.getSessionFlag());
                            int index = sessionBeanList.indexOf(tempBean);
                            if (index >= 0) {
                                //更新草稿信息
                                TalkSessionBean talkSessionBean = sessionBeanList.get(index);
                                talkSessionBean.setParam(param);

                                if (TextUtils.isEmpty(talkSessionBean.getLastMsgAccount()) &&
                                        talkSessionBean.getLastTime() > 0) {
                                    if (param.getDraftTime() > talkSessionBean.getLastTime()) {
                                        talkSessionBean.setLastTime(param.getDraftTime());
                                    }
                                }
                                if (!TextUtils.isEmpty(param.getDraftContent()) && param.getDraftTime() > 0) {
                                    talkSessionBean.setLastTime(param.getDraftTime());
                                }
                            } else {
                                //会话不存在，则生成新会话
                                if (param.getDraftTime() > 0) {
                                    TalkSessionBean talkSessionBean = new TalkSessionBean();
                                    talkSessionBean.setTalkFlag(param.getSessionFlag());
                                    talkSessionBean.setLastTime(param.getDraftTime());
                                    talkSessionBean.setParam(param);
                                    sessionBeanList.add(talkSessionBean);
                                }
                            }
                        }

                        Collections.sort(sessionBeanList);
                        //剔除重复的会话
                        mSessionList.clear();
                        Iterator<TalkSessionBean> iterator = sessionBeanList.iterator();
                        for (; iterator.hasNext(); ) {
                            TalkSessionBean bean = iterator.next();

                            int index = sessionBeanList.indexOf(bean);
                            if (index > -1 && bean != sessionBeanList.get(index)) {
                                iterator.remove();
                            }
                        }
                        mSessionList.addAll(sessionBeanList);

                        int unReadCount = 0;
                        for (TalkSessionBean bean : sessionBeanList) {
                            unReadCount += bean.getNotReadCount();//未读消息处理
                            SessionParam param = bean.getParam();
                            if (null != param && param.isDisturb()) {
                                unReadCount -= bean.getNotReadCount();
                            }
                            IMUiKitProxyImpl.getInstance().updateUnReadMessageCount(unReadCount);
                        }
                    }
                });
            }
        });
    }

    @Override
    public void registerAtOpenGroupCallBack(OnChatAt2GroupCallBack onChatAt2GroupCallBack) {
        IMUiKitProxyImpl.getInstance().setAt2GroupMembersCallback(onChatAt2GroupCallBack);
    }


    @Override
    public void openHistoryChatFile(Activity activity, String sessionId, int sessionType, boolean ifRecall) {
        Intent intent = null;
        if (sessionType == IntentParam.SESSION_TYPE_P2P) {
            intent = new Intent(activity, HistoryFileActivityPresenter.class);
        } else if (sessionType == IntentParam.SESSION_TYPE_P2G) {
            intent = new Intent(activity, HistoryFileActivityPresenter.class);
        }
        if (intent != null) {
            intent.putExtra(ConstDef.TAG_TALKFLAG, ToolUtil.getSessionTag(sessionId, sessionType));
            intent.putExtra(ConstDef.TAG_TALKERID, sessionId);
            if (ifRecall) {
                activity.startActivityForResult(intent, ConstDef.HISTORY_FILE_RECALL);
            } else {
                activity.startActivity(intent);
            }
        }
    }

    @Override
    public void notifyMeet(MeetInfo meetInfo) {
        IMModuleProxyImpl.getInstance().notifyMeet(meetInfo);
    }

    /**
     * 组件初始化
     */
    private void initComponent() {
        applicationComponent = DaggerApplicationComponent.builder()
                .applicationModule(new ApplicationModule())
                .cacheModule(new CacheModule())
                .build();

        repositoryComponent = DaggerRepositoryComponent.builder()
                .applicationComponent(applicationComponent)
                .dataStoreModule(new DataStoreModule())
                .repositoryModule(new RepositoryModule())
                .build();
    }

    /**
     * 初始化数据信息
     */
    private void initData() {
        //account
        String account = sdkParams.getAccountBean().getAccount();
        String clientId = sdkParams.getClientId();

        String ticket = "01edbce2bfca663294c99a3f8f6e497c";

        UserEntity userEntity = new UserEntity();
        userEntity.setAccount(account);
        userEntity.setTicket(ticket);
        userEntity.setClientId(clientId);
        repositoryComponent.accountCache().put(userEntity);

        CardEntity cardEntity = new CardEntity();
        int index = clientId.lastIndexOf("/") + 1;
        cardEntity.setCardId(clientId.substring(index));
        repositoryComponent.cardCache().put(cardEntity);

        NotificationUtil.getInstance().setLoginAccount(account);
        LogUtil.d("sdkParams:" + sdkParams.toString());
    }

    /**
     * PushSDK初始化
     */
    private void initPushClient() {
        PushControllerImp.getInstance().startPush(sdkParams.getClientId());
    }

    /**
     * IMServer初始化
     */
    private void initIMProxy() {
        IMModuleProxyImpl.getInstance().initIMProxy();
    }

    /**
     * IM数据库初始化
     */
    private void initDatabases() {
        String account = sdkParams.getAccountBean().getAccount();
        if (TextUtils.isEmpty(account)) {
            LogUtil.e("ERROR: Init account is null error.");
            return;
        }
        DatabaseManager.getInstance().initDatabase(sContext, account);
    }

    /**
     * 图片消息加载器
     */
    private void initImagePicker() {

        ImagePickerConfig config = new ImagePickerConfig();
        config.setColumnNum(3);              //每行显示图片个数
        config.setMaxSize(30 * 1024 * 1024); //最大可发送图片大小
        config.setMaxSelectNum(9);  //最多可选择图片个数(只有设置mode为MODE_MULTIPLE时，起作用)
        config.setMode(ImagePickerConfig.MODE_MULTIPLE);       //可多选
        config.setType(ImagePickerConfig.TYPE_IMAGE);          //只显示图片
        //config.setType(ImagePickerConfig.TYPE_WITH_CAMERA);  //显示图片和拍照
        //config.setType(ImagePickerConfig.TYPE_ALL);          //显示图片、拍照、视频

        ImagePickerManager.getInstance().setConfig(config);

        //图片加载器
        //mImageLoader = new DefaultImageLoader();
        mImageLoader = new GlideImageLoader();
        ImagePickerManager.getInstance().setImageLoader(mImageLoader);

        CameraManager.getInstance().setImageLoader(mImageLoader);
    }

    public ImageLoader getImageLoader() {
        return mImageLoader;
    }

    public RepositoryComponent getComponent() {
        return repositoryComponent;
    }

    public Context getContext() {
        return sContext;
    }

    public UiKitOptions getSdkOptions() {
        return sdkOptions;
    }

    public String getCurAccount() {
        return curAccount;
    }

    public void setCurAccount(String curAccount) {
        this.curAccount = curAccount;
    }

    public void saveCustomMsgInfo(CustomMsgInfo msgInfo) {
        repositoryComponent.proxyRepository().saveCustomIMMessage(msgInfo, new Subscriber<IMMessage>() {
            @Override
            public void onCompleted() {

            }

            @Override
            public void onError(Throwable e) {

            }

            @Override
            public void onNext(IMMessage imMessage) {
                LogUtil.d("CustomMsg", "保存自定义一消息成功");
            }
        });
    }
}
