package com.xdja.im.uikit;

import com.xdja.im.core.model.param.RemindAction;
import com.xdja.im.core.model.param.SettingParam;
import com.xdja.im.core.proxy.IMUiKitSettingProxyImpl;

/**
 * @Package: com.xdja.im.uikit.view
 * @Author: xdjaxa
 * @Creation: 2017-08-08 17:38
 * @Version V1.0
 * @Description: ImUiKit设置相关帮助类
 */
public class ImUiKitSetting implements ISetting {

    private ImUiKitSetting() {
    }

    private static class SingletonInstance {
        private static final ImUiKitSetting mInstance = new ImUiKitSetting();
    }

    public static ImUiKitSetting getInstance() {
        return SingletonInstance.mInstance;
    }

    @Override
    public SettingParam getSettingParam() {
        return IMUiKitSettingProxyImpl.getInstance().getSettingParam();
    }

    @Override
    public void setRemindType(@RemindAction.Action int action) {
        IMUiKitSettingProxyImpl.getInstance().setRemindType(action);
    }

    @Override
    public void setReceiveMode(boolean isOpen) {
        IMUiKitSettingProxyImpl.getInstance().setReceiveMode(isOpen);
    }

    @Override
    public void setDisturbMode(boolean isOpen) {
        IMUiKitSettingProxyImpl.getInstance().setDisturbMode(isOpen);
    }

    @Override
    public void setDisturbStart(long disturbStart) {
        IMUiKitSettingProxyImpl.getInstance().setDisturbStart(disturbStart);
    }

    @Override
    public void setDisturbEnd(long disturbEnd) {
        IMUiKitSettingProxyImpl.getInstance().setDisturbEnd(disturbEnd);
    }
}
