package com.xdja.im.uikit.ui.presenter;

import com.xdja.im.base.frame.Presenter;
import com.xdja.im.core.model.message.MeetInfo;

/**
 * @Package: com.xdja.im.uikit.presenter.command
 * @Author: xdjaxa
 * @Date: 2017-04-10 20:20
 * @Version V1.0
 * @Comment:
 */
public interface SessionListPresenter extends Presenter {

    /**
     * 列表项被点击
     *
     * @param position 被点击的位置
     */
    void onListItemClick(int position);

    /**
     * 删除会话
     *
     * @param position 会话位置
     */
    void deleteSession(int position);

    /**
     * 删除会话
     *
     * @param sessionFlag 会话标识
     */
    void deleteSession(String sessionFlag);

    /**
     * 删除会话配置信息
     *
     * @param sessionFlag
     */
    void deleteSessionParam(String sessionFlag);

    /**
     * 会话置顶设置
     *
     * @param position 会话位置
     */
    void setSessionTop(int position);

    /**
     * 删除会话置顶设置
     *
     * @param position 会话位置
     */
    void deleteSessionTop(int position);

    /**
     * 会话是否置顶
     *
     * @param position
     * @return
     */
    boolean isSessionTop(int position);

    /**
     * 设置会话免打扰
     *
     * @param position
     */
    void setDisturb(int position);

    /**
     * 删除会话免打扰
     *
     * @param position 会话免打扰位置
     */
    void deleteDisturb(int position);

    /**
     * 是否开启免打扰模式
     *
     * @param position
     * @return
     */
    boolean isDisturb(int position);

    /**
     * 是否展示会议标识
     * @return
     */
    MeetInfo ifShowMeetTip();
}
