package com.xdja.im.uikit.ui.view;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;

import com.xdja.im.common.utils.FileSizeUtils;
import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.VideoFileInfo;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.utils.file.FileUtils;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.im.uikit.view.ChatImageView;
import com.xdja.im.uikit.view.CircleProgressBar;

/**
 * @Package: com.xdja.im.uikit.ui
 * @Author: xdjaxa
 * @Creation: 2017-04-20 14:44
 * @Version V1.0
 * @Description:
 */
public class ViewRecvVideoItem extends BaseReceiveItem {

    /**
     * 图片加载显示控件
     */
    private ChatImageView mChatImage;
    /**
     * 播放标识
     */
    private ImageView mPlayFlagImg;
    /**
     * 视频文件加载进度
     */
    private CircleProgressBar mLoadingPBar;
    /**
     * 缩略图加载进度
     */
    private ProgressBar mLoadingPbar;
    /**
     * 视频时长显示
     */
    private TextView mVideoTimeTv;
    /**
     * 视频文件大小
     */
    private TextView mVideoSizeTv;
    /**
     * 重新下载按钮
     */
    private ImageButton mRetryBtn;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_item_chat_receive_video;
    }

    @Override
    protected void injectView() {
        super.injectView();
        mChatImage = (ChatImageView) findViewById(R.id.img_send_image);
        mPlayFlagImg = (ImageView) findViewById(R.id.img_play_flag);
        mLoadingPBar = (CircleProgressBar) findViewById(R.id.pbar_video_loading);
        mVideoTimeTv = (TextView) findViewById(R.id.tv_video_duration);
        mVideoSizeTv = (TextView) findViewById(R.id.tv_video_size);
        mLoadingPbar = (ProgressBar) findViewById(R.id.pbar_loading);
        mRetryBtn = (ImageButton) findViewById(R.id.img_retry_download);

        mPlayFlagImg.setOnLongClickListener(new View.OnLongClickListener() {
            @Override
            public boolean onLongClick(View v) {
                return showPopDialog();
            }
        });
        mPlayFlagImg.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                getPresenter().previewVideo(dataSource);
            }
        });
        mRetryBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                mLoadingPbar.setVisibility(View.VISIBLE);
                mRetryBtn.setVisibility(View.GONE);
                getPresenter().downLoadFile(dataSource.getFileInfo());
            }
        });
    }

    @Override
    public void onViewReused() {
        super.onViewReused();
        mChatImage.setImageBitmap(null);
        mContentLayout.setBackgroundResource(0);
        mLoadingPbar.setVisibility(View.GONE);
        mRetryBtn.setVisibility(View.GONE);
    }

    @Override
    public void bindDataSource(int position, @NonNull final TalkMessageBean dataSource) {
        super.bindDataSource(position, dataSource);

        VideoFileInfo videoFileInfo = (VideoFileInfo) dataSource.getFileInfo();
        if (videoFileInfo == null) {
            LogUtil.e("ERROR: video file info is null error");
            return;
        }

        mPlayFlagImg.setVisibility(View.VISIBLE);
        mVideoTimeTv.setVisibility(View.VISIBLE);
        mVideoSizeTv.setVisibility(View.VISIBLE);
        if (dataSource.getMessageState() == ConstDef.STATE_DESTROY) {
            mPlayFlagImg.setVisibility(View.GONE);
            mChatImage.setImageResource(R.mipmap.im_uikit_bg_shanxin_image);
        } else {

            if (TextUtils.isEmpty(videoFileInfo.getFilePath())) {
                //加载失败，显示重新下载按钮
                setReDownloadVisible();
                return;
            }

            mVideoTimeTv.setText(String.format(getStringRes(R.string.im_uikit_video_duration),
                    videoFileInfo.getAmountOfTime() / 60,   //分
                    videoFileInfo.getAmountOfTime() % 60)); //秒
            mVideoSizeTv.setText(FileSizeUtils.formatAutoFileSize(videoFileInfo.getRawFileSize()));

            //视频缩略图信息
            if (videoFileInfo.getFileState() == ConstDef.FAIL) {
                setProgressBarVisible(false);
                setReDownloadVisible();
                mVideoTimeTv.setVisibility(View.GONE);
                mVideoSizeTv.setVisibility(View.GONE);
            } else if (videoFileInfo.getFileState() == ConstDef.DONE) {
                setProgressBarVisible(false);
                loadImage(videoFileInfo.getFilePath());
            } else {
                setProgressBarVisible(true);
                mVideoTimeTv.setVisibility(View.GONE);
                mVideoSizeTv.setVisibility(View.GONE);
                mPlayFlagImg.setVisibility(View.GONE);
                getPresenter().downLoadFile(videoFileInfo);
            }
        }

        //发送阅读回执
        if (dataSource.getMessageState() < ConstDef.STATE_READED) {
            getPresenter().sendReadReceipt(dataSource);
        }
    }

    /**
     * 加载图片
     */
    private void loadImage(String filePath) {
        //本地文件存在
        if (FileUtils.isFileExists(filePath)) {
            mChatImage.loadImage(filePath);
            if (mContentLayout.getVisibility() == View.VISIBLE) {
                getPresenter().scrollTo(curPosition);
            }
        } else {
            mVideoTimeTv.setVisibility(View.GONE);
            mPlayFlagImg.setVisibility(View.GONE);
            mVideoSizeTv.setVisibility(View.GONE);
            mChatImage.setError(R.mipmap.im_uikit_ic_video_failed);
        }
    }

    /**
     * 当下载失败或者图片加载时，显示重新下载按钮
     */
    private void setReDownloadVisible() {

        mChatImage.setImageResource(R.mipmap.im_uikit_ic_video_failed);

        if (mRetryBtn == null) {
            LogUtil.w("ERROR:reDownloadImageBtn is null.");
            return;
        }

        mRetryBtn.setVisibility(View.VISIBLE);
    }

    /**
     * 图片加载进度是否显示
     *
     * @param isVisible
     */
    private void setProgressBarVisible(boolean isVisible) {
        if (isVisible) {
            mLoadingPbar.setVisibility(View.VISIBLE);
        } else {
            mLoadingPbar.setVisibility(View.GONE);
        }
    }
}
