package com.xdja.im.uikit.utils;


import android.content.Context;

import com.xdja.im.lib.filemanage.util.PreferencesUtil;


/**
 * Created by licong on 2017/7/20.
 * review by liming
 */
public class AtPreferencesUtils {

    private static AtPreferencesUtils wrapper;

    private PreferencesUtil preferencesUtil;

    public static AtPreferencesUtils getWrapper(Context cxt, String name) {
        if (wrapper == null) {
            synchronized (AtPreferencesUtils.class) {
                if (wrapper == null) {
                    wrapper = new AtPreferencesUtils(cxt,name);
                }
            }
        }
        return wrapper;
    }

    private AtPreferencesUtils(Context aContext, String name) {
        this.preferencesUtil = new PreferencesUtil(aContext,name);
    }


    /**
     * Set a preference string value
     *
     * @param key   the preference key to set
     * @param value the value for this key
     */
    public void setPreferenceStringValue(String key, String value) {
        this.preferencesUtil.setPreferenceStringValue(key,value);
    }

    /**
     * Set a preference boolean value
     *
     * @param key   the preference key to set
     * @param value the value for this key
     */
    public void setPreferenceBooleanValue(String key, boolean value) {
        this.preferencesUtil.setPreferenceBooleanValue(key,value);
    }

    //Private static getters
    // For string
    public String gPrefStringValue(String key) {
        return this.preferencesUtil.gPrefStringValue(key);
    }


    public Boolean gPrefBooleanValue(String key, boolean defaultValue) {
        return this.preferencesUtil.gPrefBooleanValue(key, defaultValue);
    }

    public void clearPreference() {
        this.preferencesUtil.clear();
    }


    public void removePreference(String key) {
        this.preferencesUtil.removeKey(key);
    }

    public static void clearAtAtPreferencesUtil() {
        wrapper = null;
    }
}
