package com.xdja.im.uikit.utils;

import android.content.Context;
import android.content.SharedPreferences;

import com.xdja.im.uikit.ImUiKit;

/**
 * Created by Administrator on 2018/1/8.
 * SharedPreferences 工具类
 */

public class SpUtils {

    private static SpUtils spUtils;
    private SharedPreferences sp;

    public static String meetChat = "ifShow";

    public static String meetTalkFlag = "talkFlag";

    private SpUtils() {
        sp = ImUiKit.getInstance().getContext().getSharedPreferences("chat_msg_save", Context.MODE_PRIVATE);
    }

    public static SpUtils getInstance() {
        if (spUtils == null) {
            spUtils = new SpUtils();
        }
        return spUtils;
    }

    public void saveString(String name, String value) {
        sp.edit().putString(name, value).apply();
    }

    public String getString(String name) {
        return sp.getString(name, "");
    }

    public void saveBoolean(String name, boolean value) {
        sp.edit().putBoolean(name, value).apply();
    }

    public boolean getBoolean(String name) {
        return sp.getBoolean(name, false);
    }

    public void saveInt(String name, int value) {
        sp.edit().putInt(name, value).apply();
    }

    public int getInt(String name) {
        return sp.getInt(name, -1);
    }
}
