package com.xdja.im.uikit.utils.file;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * Created by guorong on 2017/1/3.
 * 用于保存文件下载过程中百分比
 */
public class TranslateInfoUtil {

    private static Map<Long, Long> translateInfos;

    private static Map<Long, Long> getTranslateInfos() {
        if (translateInfos == null) {
            synchronized (TranslateInfoUtil.class) {
                translateInfos = new ConcurrentHashMap<>();
            }
        }
        return translateInfos;
    }

    public static void putInfo(long msgId, long size) {
        getTranslateInfos().put(msgId, size);
    }

    /**
     * 获取缓存数据值
     *
     * @param msgId
     * @return
     */
    public static long getTranslateSize(long msgId) {
        if (getTranslateInfos().containsKey(msgId)) {
            return getTranslateInfos().get(msgId);
        } else {
            return 0;
        }
    }

    /**
     * 移除缓存数据
     *
     * @param msgId
     */
    public static void remove(long msgId) {
        if (getTranslateInfos().containsKey(msgId)) {
            getTranslateInfos().remove(msgId);
        }
    }

    /**
     * 清除缓存信息
     */
    public static void clear() {
        if (translateInfos != null) {
            translateInfos.clear();
        }
    }
}
