package com.xdja.im.uikit.utils.image;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;

import java.io.IOException;
import java.io.InputStream;

/**
 * @Package: com.xdja.im.uikit.utils.image
 * @Author: xdjaxa
 * @Creation: 2017-04-11 14:06
 * @Version V1.0
 * @Description:
 */
public class BitmapUtils {

    private static final int itemh = 360;
    private static final int itemw = 360;

    /**
     * 根据图片名称获取对应的bitmap
     *
     * @param fileName 名称
     * @param resource 资源实例
     * @return
     * @throws NoSuchFieldException
     * @throws NumberFormatException
     * @throws IllegalArgumentException
     * @throws IllegalAccessException
     */
    public static Bitmap getBitmapWithName(String fileName, Resources resource)
            throws NoSuchFieldException,
            IllegalArgumentException, IllegalAccessException {
        InputStream inputStream = null;
        try {
            inputStream = resource.getAssets().open(fileName);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return BitmapFactory.decodeStream(inputStream);
    }

    /**
     * 缩小bitmap
     *
     * @param bitmap
     * @return
     */
    public static Bitmap small(Bitmap bitmap, float scale) {
        Matrix matrix = new Matrix();
        matrix.postScale(scale, scale); // 长和宽放大缩小的比例
        Bitmap resizeBmp = Bitmap.createBitmap(bitmap, 0, 0, bitmap.getWidth(),
                bitmap.getHeight(), matrix, true);
        //memory leak
        if (resizeBmp != bitmap) {
            //bitmap.recycle();
            BitmapUtils.recycleBmp(bitmap);
        }
        return resizeBmp;
    }

    /*
    * 获取压缩后的图片
    */
    public static Bitmap getZoomedDrawable(String filePath, int zoom) {

        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile(filePath, options);
        int mWidth = options.outWidth;
        int mHeight = options.outHeight;
        int s = 1;
        while ((mWidth / s > itemw * 2 * zoom)
                || (mHeight / s > itemh * 2 * zoom)) {
            s *= 2;
        }

        options = new BitmapFactory.Options();
        options.inSampleSize = s;
        options.inPreferredConfig = Bitmap.Config.ARGB_8888;
        options.inJustDecodeBounds = false;
        Bitmap bm = BitmapFactory.decodeFile(filePath, options);

        if (bm != null) {
            int h = bm.getHeight();
            int w = bm.getWidth();

            float ft = ((float) w / (float) h);
            float fs = ((float) itemw / (float) itemh);

            int neww = ft >= fs ? itemw * zoom : (int) (itemh * zoom * ft);
            int newh = ft >= fs ? (int) (itemw * zoom / ft) : itemh * zoom;

            float scaleWidth = ((float) neww) / w;
            float scaleHeight = ((float) newh) / h;

            Matrix matrix = new Matrix();
            matrix.postScale(scaleWidth, scaleHeight);
            bm = Bitmap.createBitmap(bm, 0, 0, w, h, matrix, true);
            // System.gc();
            return bm;
        }
        return null;
    }


    /*
    * 获取压缩后的图片
    */
    public static Bitmap getZoomedBitMap(Bitmap bitmap, int zoom) {

        if (bitmap != null) {
            int h = bitmap.getHeight();
            int w = bitmap.getWidth();

            float ft = ((float) w / (float) h);
            float fs = ((float) itemw / (float) itemh);

            int neww = ft >= fs ? itemw * zoom : (int) (itemh * zoom * ft);
            int newh = ft >= fs ? (int) (itemw * zoom / ft) : itemh * zoom;

            float scaleWidth = ((float) neww) / w;
            float scaleHeight = ((float) newh) / h;

            Matrix matrix = new Matrix();
            matrix.postScale(scaleWidth, scaleHeight);
            bitmap = Bitmap.createBitmap(bitmap, 0, 0, w, h, matrix, true);
            // System.gc();
            return bitmap;
        }
        return null;
    }


    public static void recycleBmp(Bitmap bitmap) {
        if (null != bitmap && !bitmap.isRecycled()) {
            bitmap = null;
        }
    }

}
