package com.xdja.im.uikit.view;

import android.annotation.SuppressLint;
import android.content.ClipboardManager;
import android.content.Context;
import android.text.Editable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.ContextMenu;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputConnectionWrapper;
import android.widget.EditText;

import com.xdja.im.common.utils.CommonTool;
import com.xdja.im.lib.emoji.utils.EmotionUtils;
import com.xdja.im.uikit.R;

/**
 * @Package: com.xdja.im.uikit.view
 * @Author: xdjaxa
 * @Creation: 2017-05-23 17:46
 * @Version V1.0
 * @Description:
 */
@SuppressLint("AppCompatCustomView")
public class PastEditText extends EditText {

    public static final int ID_PASTE = android.R.id.paste;
    public static final int ID_SELECTALL = android.R.id.selectAll;
    public static final int ID_COPY = android.R.id.copy;
    public static final int ID_CUT = android.R.id.cut;

    private final int maxLength = 2048;

    public PastEditText(Context context) {
        super(context);
    }

    public PastEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public PastEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void onCreateContextMenu(ContextMenu menu) {
        //menu.add(0, ID_SELECTALL, 0, getResources().getString(R.string.im_uikit_selectall));
        //menu.add(0, ID_CUT, 1, getResources().getString(R.string.im_uikit_cut));
        //menu.add(0, ID_COPY, 2, getResources().getString(R.string.im_uikit_copy));
        //menu.add(0, ID_PASTE, 3, getResources().getString(R.string.im_uikit_paste));
        super.onCreateContextMenu(menu);
    }

    @Override
    public boolean onTextContextMenuItem(int id) {
        switch (id) {
            case ID_PASTE:
                try {
                    ClipboardManager cmb = (ClipboardManager) getContext().getSystemService(Context.CLIPBOARD_SERVICE);
                    if (cmb.getPrimaryClip() == null) {
                        break;
                    }
                    String valueUnDeal = cmb.getText().toString();
                    String value = filterValues(valueUnDeal);
                    String preTxtStr = this.getText().toString();
                    //当前文本内容长度+剪切板中文本长度 > 输入框最大长度，不进行粘贴
                    if (preTxtStr.length() + value.length() > maxLength) {
                        int regionLength = maxLength - preTxtStr.length();
                        if (regionLength < 0 || regionLength > value.length()) {
                            return true;
                        }
                        value = value.substring(0, regionLength);
                        CommonTool.showToast(R.string.im_uikit_input_length_warnning);
                    }
                    if (!TextUtils.isEmpty(value)) {
                        try {
                            //输入框表情大小在这里设置
                            SpannableString ss = EmotionUtils.formatNormalSpanContent(value, getContext(), preTxtStr.length() + value.length());
                            if (!TextUtils.isEmpty(ss)) {
                                Editable edit = getEditableText();
                                edit.insert(getSelectionStart(), ss);
                                this.setFocusable(true);
                                return false;
                            }
                        } catch (NumberFormatException e) {
                            e.printStackTrace();
                        } catch (IllegalArgumentException e) {
                            e.printStackTrace();
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
                return true;
            default:
                break;
        }
        return super.onTextContextMenuItem(id);
    }

    /**
     * 过滤表情字符串中不全部分
     * @param value
     */
    private String filterValues(String value) {
        if(TextUtils.isEmpty(value)) {
            return "";
        }
        String[] splitEnd = value.split("\\[");
        StringBuffer sbEnd = new StringBuffer();
        for(String sbEnds :splitEnd) {
            sbEnd = sbEnd.append(sbEnds);
        }
        String valueStart = String.valueOf(sbEnd);
        String[] splitStart = valueStart.split("]");
        StringBuffer sbStart = new StringBuffer();
        for(String sbStarts :splitStart) {
            if(!sbStart.equals("")) {
                sbStart = sbStart.append("["+ sbStarts +"]");
            }
        }
        return String.valueOf(sbStart);
    }

    @Override
    public InputConnection onCreateInputConnection(EditorInfo outAttrs) {
        return new ZanyInputConnection(super.onCreateInputConnection(outAttrs), true);
    }

    private class ZanyInputConnection extends InputConnectionWrapper {

        public ZanyInputConnection(InputConnection target, boolean mutable) {
            super(target, mutable);
        }

        @Override
        public boolean deleteSurroundingText(int beforeLength, int afterLength) {
            return super.deleteSurroundingText(beforeLength, afterLength);
        }

        @Override
        public boolean commitText(CharSequence text, int newCursorPosition) {
            int length = PastEditText.this.getText().length();

            if (length >= PastEditText.this.maxLength) {
                CommonTool.showToast(R.string.im_uikit_input_length_warnning);
                return false;
            }

            if (EmotionUtils.mathEmotion(text.toString())) {
                Editable edit = getEditableText();
                SpannableString ss = EmotionUtils.formatNormalSpanContent(text, getContext());
                edit.insert(getSelectionStart(), ss);
                return false;
            }
            return super.commitText(text, newCursorPosition);
        }
    }
}
