/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.http.client.protocol;

import com.xdja.http.Header;
import com.xdja.http.HttpException;
import com.xdja.http.HttpRequest;
import com.xdja.http.HttpRequestInterceptor;
import com.xdja.http.annotation.Immutable;
import com.xdja.http.protocol.HttpContext;
import com.xdja.http.util.Args;
import java.io.IOException;
import java.util.Collection;

@Immutable
public class RequestDefaultHeaders
implements HttpRequestInterceptor {
    private final Collection<? extends Header> defaultHeaders;

    public RequestDefaultHeaders(Collection<? extends Header> defaultHeaders) {
        this.defaultHeaders = defaultHeaders;
    }

    public RequestDefaultHeaders() {
        this(null);
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            return;
        }
        Collection<? extends Header> defHeaders = (Collection<? extends Header>)request.getParams().getParameter("http.default-headers");
        if (defHeaders == null) {
            defHeaders = this.defaultHeaders;
        }
        if (defHeaders != null) {
            for (Header header : defHeaders) {
                request.addHeader(header);
            }
        }
    }
}

