/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.db.dao;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;
import com.xdja.imsdk.db.bean.SyncIdDb;
import com.xdja.imsdk.db.builder.SyncIdBuilder;
import com.xdja.imsdk.db.dao.AbstractDao;
import com.xdja.imsdk.db.helper.UpdateArgs;
import com.xdja.imsdk.util.ToolUtils;
import java.util.List;

public class SyncIdDao
extends AbstractDao<SyncIdDb> {
    private static SyncIdDao instance;

    private SyncIdDao() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SyncIdDao getInstance() {
        if (instance != null) return instance;
        Class<SyncIdDao> clazz = SyncIdDao.class;
        synchronized (SyncIdDao.class) {
            if (instance != null) return instance;
            instance = new SyncIdDao();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void insertBatch(List<SyncIdDb> ids) {
        if (ids == null || ids.isEmpty()) {
            return;
        }
        this.insertBatch(ids, SyncIdBuilder.insertSql());
    }

    public void insertBatchUpgrade(SQLiteDatabase db, List<SyncIdDb> ids) {
        if (ids == null || ids.isEmpty()) {
            return;
        }
        this.insertBatchUpgrade(db, ids, SyncIdBuilder.insertSql());
    }

    public void updateS(UpdateArgs args) {
        this.update(args);
    }

    public void updateSBatch(List<UpdateArgs> argsList) {
        this.updateBatch(SyncIdBuilder.updateValueSql(), argsList);
    }

    public long getSyncId(String key) {
        long value;
        block7: {
            value = 0L;
            Cursor cursor = null;
            SyncIdDb db = null;
            try {
                try {
                    cursor = this.query(SyncIdBuilder.queryValue(key));
                    if (cursor != null && cursor.moveToNext()) {
                        db = this.readEntry(cursor, 0);
                    }
                    if (db != null) {
                        value = ToolUtils.getLong(db.getId_value());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.closeCursor(cursor);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                this.closeCursor(cursor);
                throw throwable;
            }
            this.closeCursor(cursor);
        }
        return value;
    }

    public int getCount() {
        int count = 0;
        Cursor cursor = null;
        try {
            try {
                cursor = this.query(SyncIdBuilder.queryCount());
                if (cursor != null && cursor.moveToNext()) {
                    count = cursor.getCount();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.closeCursor(cursor);
            }
        }
        finally {
            this.closeCursor(cursor);
        }
        return count;
    }

    @Override
    protected SyncIdDb readEntry(Cursor cursor, int offset) {
        SyncIdDb entity = new SyncIdDb(cursor.isNull(offset + 0) ? null : Long.valueOf(cursor.getLong(offset + 0)), cursor.isNull(offset + 1) ? null : cursor.getString(offset + 1), cursor.isNull(offset + 2) ? null : cursor.getString(offset + 2));
        return entity;
    }

    @Override
    protected void bindValues(SQLiteStatement stmt, SyncIdDb entry) {
        String id_value;
        String id_type;
        stmt.clearBindings();
        Long id = entry.getId();
        if (id != null) {
            stmt.bindLong(1, id.longValue());
        }
        if ((id_type = entry.getId_type()) != null) {
            stmt.bindString(2, id_type);
        }
        if ((id_value = entry.getId_value()) != null) {
            stmt.bindString(3, id_value);
        }
    }
}

