/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.http.okhttp;

import android.content.Context;
import com.xdja.imsdk.http.RequestInfo;
import com.xdja.imsdk.http.SecurityHttps;
import com.xdja.imsdk.http.callback.IPostCallback;
import com.xdja.imsdk.http.okhttp.OkHttpRequest;
import com.xdja.imsdk.logger.Logger;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class OkHttpUtil {
    private static OkHttpUtil instance;
    private static OkHttpClient okHttpClient;
    private static OkHttpClient okHttpsClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OkHttpUtil getInstance() {
        Class<OkHttpUtil> clazz = OkHttpUtil.class;
        synchronized (OkHttpUtil.class) {
            if (instance == null) {
                instance = Factory.getInstance();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void init() {
        if (okHttpClient == null) {
            okHttpClient = new OkHttpClient.Builder().connectTimeout(15L, TimeUnit.SECONDS).writeTimeout(20L, TimeUnit.SECONDS).readTimeout(20L, TimeUnit.SECONDS).hostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            }).build();
        }
    }

    public void init(Context context, int storeId, String pwd) {
        if (okHttpsClient == null) {
            SecurityHttps.SSLParams sslParams = SecurityHttps.getSSLParams(context, storeId, pwd);
            okHttpsClient = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).writeTimeout(20L, TimeUnit.SECONDS).readTimeout(20L, TimeUnit.SECONDS).hostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            }).sslSocketFactory(sslParams.sSLSocketFactory).build();
        }
        if (okHttpClient == null) {
            okHttpClient = new OkHttpClient.Builder().connectTimeout(15L, TimeUnit.SECONDS).writeTimeout(20L, TimeUnit.SECONDS).readTimeout(20L, TimeUnit.SECONDS).hostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            }).build();
        }
    }

    public void cancel() {
    }

    public void cancelAll() {
    }

    public void getSync() {
    }

    public void postSync() {
    }

    public void getAsync() {
    }

    public void postAsync(final RequestInfo requestInfo, final IPostCallback callback) {
        if (requestInfo == null) {
            Logger.getLogger().e("request exception!!!");
            return;
        }
        final OkHttpClient client = this.getOkHttpClient(requestInfo.isHttps());
        if (client == null) {
            Logger.getLogger().e("request exception!!!");
            return;
        }
        Request request = OkHttpRequest.builderRequest(requestInfo);
        client.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                this.retryPolicy(call);
                Logger.getLogger().d("ImSdk request fail " + requestInfo + ", error:" + e);
            }

            public void onResponse(Call call, Response response) throws IOException {
                Logger.getLogger().d("ImSdk request onResponse " + requestInfo);
                try {
                    if (response.isSuccessful()) {
                        callback.onSuccess(response.body().string(), requestInfo);
                    } else {
                        Logger.getLogger().d("ImSdk request onResponse fail " + requestInfo + ", response:" + response);
                        this.retryPolicy(call);
                    }
                }
                catch (Exception e) {
                    Logger.getLogger().d("ImSdk request onResponse exception " + requestInfo + ", error:" + e);
                    this.retryPolicy(call);
                }
            }

            private void retryPolicy(Call call) {
                if (OkHttpUtil.this.attemptRetry(requestInfo)) {
                    client.newCall(call.request()).enqueue((Callback)this);
                } else {
                    callback.onFailed(40000, requestInfo);
                }
            }
        });
    }

    public void uploadFileAsync() {
    }

    public void downloadFileAsync() {
    }

    private OkHttpClient getOkHttpClient(boolean isHttps) {
        if (isHttps) {
            return okHttpsClient;
        }
        return okHttpClient;
    }

    private boolean attemptRetry(RequestInfo requestInfo) {
        if (requestInfo == null) {
            return false;
        }
        return false;
    }

    private static class Factory {
        private Factory() {
        }

        static OkHttpUtil getInstance() {
            return new OkHttpUtil();
        }
    }
}

