/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.manager.build;

import android.text.TextUtils;
import com.xdja.imsdk.http.RequestInfo;
import com.xdja.imsdk.http.receipt.request.MssBatchUpdateRequest;
import com.xdja.imsdk.http.receipt.request.MssGetRequest;
import com.xdja.imsdk.manager.ImSdkConfigManager;
import com.xdja.imsdk.util.JsonUtil;
import java.util.HashMap;

public class RequestFactory {
    private static String baseUrl;

    public static RequestInfo buildMssRead(String groupId, String msgId, String ticket) {
        RequestInfo info = new RequestInfo();
        info.setType(RequestInfo.RequestType.READ);
        String url = String.valueOf(RequestFactory.getBaseUrl()) + "/mss/get";
        info.setUrl(url);
        MssGetRequest getRequest = new MssGetRequest(groupId, msgId);
        info.setJson(JsonUtil.toJson(getRequest));
        HashMap<String, String> head = new HashMap<String, String>();
        head.put("ticket", ticket);
        info.setHeaders(head);
        info.setHttps(RequestFactory.isHttps());
        return info;
    }

    public static RequestInfo buildMssReceipt() {
        RequestInfo info = new RequestInfo();
        info.setType(RequestInfo.RequestType.RECEIPT);
        String url = String.valueOf(RequestFactory.getBaseUrl()) + "/mss/update";
        info.setUrl(url);
        return info;
    }

    public static RequestInfo buildMssReceipts(long id, MssBatchUpdateRequest request, String ticket) {
        RequestInfo info = new RequestInfo();
        info.setType(RequestInfo.RequestType.RECEIPTS);
        String url = String.valueOf(RequestFactory.getBaseUrl()) + "/mss/batchupdate";
        info.setUrl(url);
        info.setJson(JsonUtil.toJson(request));
        info.setTag(String.valueOf(id));
        HashMap<String, String> head = new HashMap<String, String>();
        head.put("ticket", ticket);
        info.setHeaders(head);
        info.setHttps(RequestFactory.isHttps());
        return info;
    }

    private static String getBaseUrl() {
        if (TextUtils.isEmpty((CharSequence)baseUrl)) {
            baseUrl = ImSdkConfigManager.getInstance().getMssBaseUrl();
        }
        return baseUrl;
    }

    public static boolean isHttps() {
        return ImSdkConfigManager.getInstance().isHttps();
    }
}

