/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.volley.stack;

import android.annotation.SuppressLint;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.xdja.imsdk.volley.stack.HurlStack;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public class HttpsStackUtil {
    private static final String TAG = "HttpsurlStack";
    private static String DEFAULT_PASSWORD = "111111";

    public static HurlStack getHttpsStack(Context context, int storeId, String pwd) {
        if (!TextUtils.isEmpty((CharSequence)pwd)) {
            DEFAULT_PASSWORD = pwd;
        }
        SSLContext sslContext = HttpsStackUtil.getSSLContext(HttpsStackUtil.readKeyStore(context, storeId));
        return new HurlStack(null, sslContext.getSocketFactory());
    }

    private static KeyStore readKeyStore(Context cxt, int res) {
        InputStream inputStream = null;
        KeyStore keyStore = null;
        try {
            try {
                keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                inputStream = cxt.getResources().openRawResource(res);
                keyStore.load(inputStream, DEFAULT_PASSWORD.toCharArray());
            }
            catch (KeyStoreException kse) {
                Log.e((String)TAG, (String)kse.getMessage());
            }
            catch (CertificateException ce) {
                Log.e((String)TAG, (String)ce.getMessage());
            }
            catch (NoSuchAlgorithmException ne) {
                Log.e((String)TAG, (String)ne.getMessage());
            }
            catch (IOException ie) {
                Log.e((String)TAG, (String)ie.getMessage());
            }
        }
        catch (Throwable throwable) {}
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return keyStore;
    }

    @SuppressLint(value={"TrulyRandom"})
    private static SSLContext getSSLContext(KeyStore keyStore) {
        if (keyStore == null) {
            return null;
        }
        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance("TLS");
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, DEFAULT_PASSWORD.toCharArray());
            sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), new SecureRandom());
        }
        catch (NoSuchAlgorithmException ne) {
            Log.e((String)TAG, (String)ne.getMessage());
        }
        catch (KeyStoreException ke) {
            Log.e((String)TAG, (String)ke.getMessage());
        }
        catch (UnrecoverableKeyException ue) {
            Log.e((String)TAG, (String)ue.getMessage());
        }
        catch (KeyManagementException ke) {
            Log.e((String)TAG, (String)ke.getMessage());
        }
        return sslContext;
    }
}

