/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.common.database.dao;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;
import android.text.TextUtils;
import com.xdja.im.common.database.DatabaseManager;
import com.xdja.im.common.database.bean.SessionDb;
import com.xdja.im.common.database.builder.SessionEntityBuilder;
import com.xdja.im.common.database.dao.AbstractDao;
import com.xdja.im.common.database.helper.UpdateArgs;
import java.util.ArrayList;
import java.util.List;

public class SessionEntityDao
extends AbstractDao<SessionDb> {
    private SessionEntityDao() {
    }

    public static SessionEntityDao getInstance() {
        return SingletonInstance.mInstance;
    }

    public long insert(SessionDb sessionDb) {
        SQLiteDatabase db = this.getDatabase();
        if (db != null) {
            return this.insert(db, sessionDb, SessionEntityBuilder.insertSql());
        }
        return -1L;
    }

    @Override
    public int delete(String sessionFlag) {
        if (TextUtils.isEmpty((CharSequence)sessionFlag)) {
            return -1;
        }
        return super.delete(SessionEntityBuilder.delSql(sessionFlag));
    }

    public int deleteAll() {
        return super.delete(SessionEntityBuilder.delAllSql());
    }

    public void deleteOnlyDraft(String sessionFlag) {
        UpdateArgs args = new UpdateArgs("t_session");
        ContentValues values = new ContentValues();
        values.put("draftContent", "");
        values.put("draftCreateTime", Integer.valueOf(0));
        String[] whereClause = new String[]{"sessionFlag"};
        String[] whereArgs = new String[]{sessionFlag};
        args.setValues(values);
        args.setWhereClause(whereClause);
        args.setWhereArgs(whereArgs);
        this.update(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionDb get(String sessionFlag) {
        SessionDb msgEntryDb = null;
        Cursor cursor = null;
        try {
            cursor = this.query(SessionEntityBuilder.querySql(sessionFlag));
            if (cursor != null && cursor.moveToNext()) {
                msgEntryDb = this.readEntry(cursor, 0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.closeCursor(cursor);
        }
        return msgEntryDb;
    }

    public void update(SessionDb sessionDb) {
        UpdateArgs args = new UpdateArgs("t_session");
        ContentValues values = new ContentValues();
        values.put("sessionFlag", sessionDb.getSessionFlag());
        values.put("sessionMode", Integer.valueOf(sessionDb.getSessionMode()));
        values.put("sessionDisturb", Integer.valueOf(sessionDb.getSessionDisturb()));
        values.put("receiverMode", Integer.valueOf(sessionDb.getReceiveMode()));
        values.put("draftContent", sessionDb.getDraftContent());
        values.put("draftCreateTime", Long.valueOf(sessionDb.getDraftCreateTime()));
        String[] whereClause = new String[]{"sessionFlag"};
        String[] whereArgs = new String[]{sessionDb.getSessionFlag()};
        args.setValues(values);
        args.setWhereClause(whereClause);
        args.setWhereArgs(whereArgs);
        this.update(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SessionDb> getAll() {
        ArrayList<SessionDb> sessionDbList = new ArrayList<SessionDb>();
        Cursor cursor = null;
        try {
            cursor = this.query(SessionEntityBuilder.queryAll());
            while (cursor != null && cursor.moveToNext()) {
                sessionDbList.add(this.readEntry(cursor, 0));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.closeCursor(cursor);
        }
        return sessionDbList;
    }

    @Override
    protected SessionDb readEntry(Cursor cursor, int offset) {
        SessionDb entity = new SessionDb(cursor.isNull(offset + 0) ? null : Long.valueOf(cursor.getLong(offset + 0)), cursor.isNull(offset + 1) ? null : cursor.getString(offset + 1), cursor.isNull(offset + 2) ? null : Integer.valueOf(cursor.getInt(offset + 2)), cursor.isNull(offset + 3) ? null : Integer.valueOf(cursor.getInt(offset + 3)), cursor.isNull(offset + 4) ? null : Integer.valueOf(cursor.getInt(offset + 4)), cursor.isNull(offset + 5) ? null : cursor.getString(offset + 5), cursor.isNull(offset + 6) ? null : Long.valueOf(cursor.getLong(offset + 6)));
        return entity;
    }

    @Override
    protected void bindValues(SQLiteStatement stmt, SessionDb entity) {
        Long draftCreateTime;
        String draftContent;
        Integer receiveMode;
        Integer sessionDisturb;
        Integer sessionMode;
        String sessionFlag;
        stmt.clearBindings();
        Long id2 = entity.getId();
        if (id2 != null) {
            stmt.bindLong(1, id2.longValue());
        }
        if ((sessionFlag = entity.getSessionFlag()) != null) {
            stmt.bindString(2, sessionFlag);
        }
        if ((sessionMode = Integer.valueOf(entity.getSessionMode())) != null) {
            stmt.bindLong(3, (long)sessionMode.intValue());
        }
        if ((sessionDisturb = Integer.valueOf(entity.getSessionDisturb())) != null) {
            stmt.bindLong(4, (long)sessionDisturb.intValue());
        }
        if ((receiveMode = Integer.valueOf(entity.getReceiveMode())) != null) {
            stmt.bindLong(5, (long)receiveMode.intValue());
        }
        if ((draftContent = entity.getDraftContent()) != null) {
            stmt.bindString(6, draftContent);
        }
        if ((draftCreateTime = Long.valueOf(entity.getDraftCreateTime())) != null) {
            stmt.bindLong(7, draftCreateTime.longValue());
        }
    }

    private SQLiteDatabase getDatabase() {
        SQLiteDatabase db = DatabaseManager.getInstance().getDatabase();
        if (db == null) {
            throw new IllegalAccessError("open database failed.");
        }
        return db;
    }

    private static class SingletonInstance {
        private static final SessionEntityDao mInstance = new SessionEntityDao();

        private SingletonInstance() {
        }
    }
}

