/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.core.utils;

import android.content.Context;
import android.os.Environment;
import com.xdja.http.util.TextUtils;
import com.xdja.im.uikit.ImUiKit;
import com.xdja.im.uikit.UiKitOptions;
import com.xdja.imsdk.util.FileUtils;
import com.xdja.imsdk.util.ToolUtils;
import java.io.File;

public class FilePathUtils {
    public static final String PATENT_PATH = "XdjaIm";
    public static final String PARENT_IMAGE_RECV = "ImageRec";
    public static final String PARENT_VIDEO_RECV = "VideoRec";
    public static final String PARENT_FILE_RECV = "FileRec";

    public static String getSessionTag(String id2, int type) {
        return ToolUtils.getSessionTag((String)id2, (int)type);
    }

    public static String getLastString(String input, String separator) {
        return ToolUtils.getLastString((String)input, (String)separator);
    }

    public static String getSdkCacheDir() {
        try {
            String cacheDir = UiKitOptions.getOptions().getCacheDir();
            if (!TextUtils.isEmpty((CharSequence)cacheDir)) {
                File parentDir = new File(cacheDir);
                if (!parentDir.exists()) {
                    parentDir.mkdirs();
                }
                return parentDir.getAbsolutePath() + File.separator;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Context context = ImUiKit.getInstance().getContext();
        if (context != null) {
            return Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator + context.getPackageName() + File.separator;
        }
        return Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator;
    }

    public static String getAppParent() {
        try {
            String cacheDir = UiKitOptions.getOptions().getCacheDir();
            if (!TextUtils.isEmpty((CharSequence)cacheDir)) {
                File parentDir = new File(cacheDir);
                if (!parentDir.exists()) {
                    parentDir.mkdirs();
                }
                File dir = new File(cacheDir, PATENT_PATH);
                return dir.getAbsolutePath() + File.separator;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator + PATENT_PATH + File.separator;
    }

    public static String getImageRecPath() {
        return FilePathUtils.getAppParent() + PARENT_IMAGE_RECV + File.separator;
    }

    public static String getVideoRecPath() {
        return FilePathUtils.getAppParent() + PARENT_VIDEO_RECV + File.separator;
    }

    public static String getFileRecPath() {
        return FilePathUtils.getAppParent() + PARENT_FILE_RECV + File.separator;
    }

    public static String getImagePath() {
        return FileUtils.getImagePath();
    }

    public static String getVoicePath() {
        return FileUtils.getVoicePath();
    }

    public static String getVideoPath() {
        return FileUtils.getVideoPath();
    }
}

