/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.filemanage.view;

import android.content.SharedPreferences;
import android.graphics.Color;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.DisplayMetrics;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.xdja.im.common.utils.FileSizeUtils;
import com.xdja.im.lib.filemanage.commend.IFileExplorerCommand;
import com.xdja.im.lib.filemanage.commend.IFileExplorerVu;
import com.xdja.im.lib.filemanage.view.ImpActivitySuperView;
import com.xdja.im.uikit.R;

public class ViewFileExplorer
extends ImpActivitySuperView<IFileExplorerCommand>
implements IFileExplorerVu<IFileExplorerCommand>,
ViewPager.OnPageChangeListener {
    private ViewPager mViewPager;
    private ProgressBar mLoadingPBar;
    private TextView mSelectedFileSizeTv;
    private Button mSendBtn;
    private ImageView mCursorImg;
    private int mCursorW = 0;
    private TextView[] mTabTvs;
    private SharedPreferences sharedPreferences;

    @Override
    protected int getLayoutRes() {
        return R.layout.imuikit_activity_file_explorer;
    }

    @Override
    protected int getToolbarType() {
        return 0;
    }

    @Override
    protected int getToolbarTitle() {
        return R.string.im_uikit_select_file;
    }

    @Override
    protected void injectView() {
        super.injectView();
        this.mViewPager = (ViewPager)this.getView().findViewById(R.id.pager_file_explorer);
        this.mLoadingPBar = (ProgressBar)this.getView().findViewById(R.id.pbar_loading);
        this.mSelectedFileSizeTv = (TextView)this.getView().findViewById(R.id.tv_file_select_size);
        this.mSendBtn = (Button)this.getView().findViewById(R.id.btn_send);
        this.mCursorImg = (ImageView)this.getView().findViewById(R.id.img_cursor);
        TextView mTabLastFileTv = (TextView)this.getView().findViewById(R.id.tv_last_files);
        TextView mTabLocalFileTv = (TextView)this.getView().findViewById(R.id.tv_local_files);
        this.mTabTvs = new TextView[]{mTabLastFileTv, mTabLocalFileTv};
        this.mTabTvs[0].setTextColor(this.getColorRes(R.color.base_black_95));
        DisplayMetrics dm = new DisplayMetrics();
        this.getActivity().getWindowManager().getDefaultDisplay().getMetrics(dm);
        int screenW = dm.widthPixels;
        this.mCursorW = screenW / this.mTabTvs.length;
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.mCursorImg.getLayoutParams();
        params.width = this.mCursorW;
        this.mCursorImg.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mViewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        this.sharedPreferences = this.getActivity().getSharedPreferences("PageTabPositionRecord", 0);
    }

    @Override
    public void setProgressBarVisibility(int visibility) {
        this.mLoadingPBar.setVisibility(visibility);
    }

    @Override
    public void setFragmentAdapter(PagerAdapter adapter) {
        this.mViewPager.setAdapter(adapter);
        this.mViewPager.setCurrentItem(this.sharedPreferences.getInt("selected_file_page_position", 0));
    }

    @Override
    public void onDestroy() {
        SharedPreferences.Editor editor = this.sharedPreferences.edit();
        editor.putInt("selected_file_page_position", this.mViewPager.getCurrentItem());
        editor.apply();
        super.onDestroy();
    }

    @Override
    public void setViewPagerCurrentItem(int item) {
        this.mViewPager.setCurrentItem(item);
        this.resetTabColor();
        this.mTabTvs[item].setTextColor(this.getColorRes(R.color.base_black_95));
        this.cursorAnim(item);
    }

    @Override
    public void setCurrentSelectedFileSize(long size) {
        this.mSelectedFileSizeTv.setText((CharSequence)String.format(this.getStringRes(R.string.im_uikit_file_select_size), FileSizeUtils.FormetFileSize(size)));
    }

    @Override
    public void setCurrentSelectedFileCount(int selectCount) {
        if (selectCount == 0) {
            this.mSendBtn.setText(R.string.im_uikit_send);
            this.mSendBtn.setClickable(false);
            this.mSendBtn.setTextColor(Color.parseColor((String)"#77000000"));
        } else {
            this.mSendBtn.setClickable(true);
            this.mSendBtn.setTextColor(Color.parseColor((String)"#F3000000"));
            this.mSendBtn.setText((CharSequence)String.format(this.getStringRes(R.string.im_uikit_send_indicator), selectCount));
        }
    }

    private void cursorAnim(int curItem) {
        int mCursorX = 0;
        this.mCursorImg.setX((float)(mCursorX + this.mCursorW * curItem));
    }

    private void resetTabColor() {
        for (TextView mTabTv : this.mTabTvs) {
            mTabTv.setTextColor(this.getColorRes(R.color.base_black_37));
        }
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
    }

    public void onPageSelected(int position) {
        this.resetTabColor();
        this.mTabTvs[position].setTextColor(this.getColorRes(R.color.base_black_95));
        this.cursorAnim(position);
    }

    public void onPageScrollStateChanged(int state) {
    }
}

