/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.historyfile.util;

import android.text.TextUtils;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.core.model.message.file.ImageFileInfo;
import com.xdja.im.core.model.message.file.VideoFileInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HistoryModeUtils {
    private static final Map<Long, TalkMessageBean> mLocalFileInfo = new HashMap<Long, TalkMessageBean>();

    private HistoryModeUtils() {
    }

    public static HistoryModeUtils getInstance() {
        return SingletonInstance.mInstance;
    }

    private TalkMessageBean getFileFromCache(String key) {
        return mLocalFileInfo.get(key);
    }

    public void putFileToSelectedCache(long key, TalkMessageBean fileInfo) {
        if (fileInfo != null) {
            mLocalFileInfo.put(key, fileInfo);
        }
    }

    public void removeToSelectedCache(long key) {
        mLocalFileInfo.remove(key);
    }

    public List<TalkMessageBean> getAllSelectFiles() {
        ArrayList<TalkMessageBean> fileInfoList = new ArrayList<TalkMessageBean>();
        for (long key : mLocalFileInfo.keySet()) {
            fileInfoList.add(mLocalFileInfo.get(key));
        }
        return fileInfoList;
    }

    public long getSelectRawFileSize() {
        long size = 0L;
        ArrayList<TalkMessageBean> fileList = new ArrayList<TalkMessageBean>(mLocalFileInfo.values());
        for (TalkMessageBean bean : fileList) {
            FileInfo fileInfo = bean.getFileInfo();
            if (fileInfo instanceof ImageFileInfo) {
                if (((ImageFileInfo)fileInfo).isOriginal()) {
                    size += ((ImageFileInfo)fileInfo).getRawFileInfo().getFileSize();
                    continue;
                }
                if (TextUtils.equals((CharSequence)"gif", (CharSequence)fileInfo.getSuffix())) {
                    size += ((ImageFileInfo)fileInfo).getGifFileInfo().getFileSize();
                    continue;
                }
                size += fileInfo.getFileSize();
                continue;
            }
            if (fileInfo instanceof VideoFileInfo) {
                size += ((VideoFileInfo)fileInfo).getRawFileInfo().getFileSize();
                continue;
            }
            size += fileInfo.getFileSize();
        }
        return size;
    }

    public int getSelectedFileCount() {
        return mLocalFileInfo.size();
    }

    public void clearCache() {
        mLocalFileInfo.clear();
    }

    private static class SingletonInstance {
        private static final HistoryModeUtils mInstance = new HistoryModeUtils();

        private SingletonInstance() {
        }
    }
}

