/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.notification;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.SystemClock;
import android.os.Vibrator;
import android.support.annotation.NonNull;
import android.support.v4.app.NotificationCompat;
import android.text.TextUtils;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.animation.GlideAnimation;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.target.Target;
import com.xdja.im.common.utils.CommonTool;
import com.xdja.im.core.model.param.DisturbParam;
import com.xdja.im.core.model.param.RemindParam;
import com.xdja.im.core.model.param.SettingParam;
import com.xdja.im.core.repository.interf.datasource.DiskDataStore;
import com.xdja.im.uikit.ImUiKit;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.notification.NotifyConstant;
import com.xdja.im.uikit.notification.NotifyUtils;
import com.xdja.im.uikit.utils.image.ImageUtils;
import com.xdja.im.uikit.utils.log.LogUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import rx.Subscriber;

public class NotificationUtil {
    private static final int DISTANCE_TIME = 3000;
    private static final String NOT_NOTIFY_ACTIVITY = "com.xdja.im.uikit.ui.activity.ChatListActivity";
    private Context mContext;
    private long addPushTime;
    private boolean isCurrentTalker = false;
    private final ArrayList<NotificationBean> singleNotifyList = new ArrayList();
    private final ArrayList<NotificationBean> groupNotifyList = new ArrayList();
    private Set<String> accounts = new HashSet<String>();
    private MediaPlayer player = null;
    private NotificationManager notifyManager;
    private DiskDataStore diskDataStore;
    private String loginAccount;
    private String mCurTalkAccount;
    private String CHANNEL_ID = "my_imuikit_channel";
    private CharSequence name = "my_imuikit";

    public static NotificationUtil getInstance() {
        return SingletonInstance.mInstance;
    }

    private NotificationUtil() {
        this.mContext = ImUiKit.getInstance().getContext();
        this.notifyManager = (NotificationManager)this.mContext.getSystemService("notification");
        if (Build.VERSION.SDK_INT >= 26) {
            int importance = 4;
            NotificationChannel mChannel = new NotificationChannel(this.CHANNEL_ID, this.name, importance);
            mChannel.enableLights(true);
            mChannel.enableVibration(false);
            mChannel.setShowBadge(false);
            this.notifyManager.createNotificationChannel(mChannel);
        }
        if (ImUiKit.getInstance().getComponent() != null) {
            this.diskDataStore = ImUiKit.getInstance().getComponent().diskDataStore();
        }
    }

    public void setLoginAccount(String account) {
        this.loginAccount = account;
    }

    public void setCurTalkAccount(String account) {
        this.mCurTalkAccount = account;
    }

    public void remindMessage(String account, String imgUrl, String userName, String talkId, int talkType, int msgSize, long msgTime, boolean isDisturb) {
        NotifyConstant.getAction();
        NotifyContactInfo info = new NotifyContactInfo(account, imgUrl, userName, msgTime);
        NewMessageInfo msgInfo = new NewMessageInfo(talkId, msgSize, talkType, isDisturb);
        this.accounts.add(account);
        this.initNotifications(info, msgInfo);
    }

    private void initNotifications(final NotifyContactInfo contactInfo, final NewMessageInfo newMsgInfo) {
        List<Object> notifyBeans = new ArrayList();
        if (this.accounts.contains(contactInfo.account)) {
            notifyBeans = this.addNotificationBean(contactInfo, newMsgInfo);
        }
        if (TextUtils.isEmpty((CharSequence)this.loginAccount)) {
            LogUtil.e("ERROR: Current login account is null.");
            return;
        }
        if (notifyBeans == null || notifyBeans.isEmpty()) {
            LogUtil.e("ERROR: Notify bean is null.");
            return;
        }
        final List<Object> finalNotifyBeans = notifyBeans;
        this.diskDataStore.loadSettingParams(new Subscriber<SettingParam>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
            }

            public void onNext(SettingParam settingParam) {
                if (settingParam == null) {
                    LogUtil.w("Load setting param is null.");
                    return;
                }
                RemindParam remind = settingParam.getRemind();
                DisturbParam disturb = settingParam.getDisturb();
                if (disturb != null && disturb.isOpen() && NotificationUtil.this.isInNoDisturb(disturb.getStartTime(), disturb.getEndTime()) && !remind.isOpen()) {
                    LogUtil.d("Current is within disturb.");
                    return;
                }
                if (!remind.isOpen()) {
                    LogUtil.d("Remind is close.");
                    return;
                }
                NotificationUtil.this.sendNotify(finalNotifyBeans, newMsgInfo, contactInfo);
            }
        });
    }

    private void sendNotify(List<NotificationBean> finalNotifyBeans, NewMessageInfo newMsgInfo, NotifyContactInfo contactInfo) {
        String[] showMessages = new String[2];
        int newCount = 0;
        int size = finalNotifyBeans.size();
        StringBuilder sbName = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            NotificationBean notificationBean = finalNotifyBeans.get(i);
            String name = TextUtils.isEmpty((CharSequence)notificationBean.accountName) ? CommonTool.getString(R.string.im_uikit_group_name_default) : notificationBean.accountName;
            sbName.append(name);
            newCount += notificationBean.msgCount;
            if (i == finalNotifyBeans.size() - 1) continue;
            if (newMsgInfo.talkType == 2) {
                sbName.append("\uff1b");
                continue;
            }
            sbName.append("\u3001");
        }
        showMessages[0] = sbName.toString();
        showMessages[1] = CommonTool.getString(R.string.im_uikit_notify_prestr) + newCount + CommonTool.getString(R.string.im_uikit_notify_endstr);
        this.showNotificationHeader(contactInfo, newMsgInfo, showMessages);
    }

    private void showNotificationHeader(final NotifyContactInfo contactInfo, final NewMessageInfo newMsgInfo, final String[] messages) {
        String imageUrl = null;
        if (newMsgInfo.talkType == 2) {
            if (this.groupNotifyList.size() > 0) {
                NotificationBean lastBean = this.groupNotifyList.get(0);
                imageUrl = lastBean.imageUrl;
            }
        } else if (this.singleNotifyList.size() > 0) {
            NotificationBean lastBean = this.singleNotifyList.get(0);
            imageUrl = lastBean.imageUrl;
        }
        Glide.with((Context)this.mContext).load(imageUrl).asBitmap().into((Target)new SimpleTarget<Bitmap>(){

            public void onResourceReady(Bitmap resource, GlideAnimation<? super Bitmap> glideAnimation) {
                Bitmap bitmap = ImageUtils.getRoundedCornerBitmap(resource);
                NotificationUtil.this.notifyMessage(bitmap, messages, contactInfo, newMsgInfo);
            }

            public void onLoadFailed(Exception e, Drawable errorDrawable) {
                super.onLoadFailed(e, errorDrawable);
                Drawable drawable2 = CommonTool.getDrawable(R.mipmap.im_uikit_user_header_40dp);
                if (newMsgInfo.talkType == 2) {
                    drawable2 = CommonTool.getDrawable(R.mipmap.im_uikit_user_header_40dp);
                }
                Bitmap largeBitmap = ImageUtils.drawableToBitmap(drawable2);
                NotificationUtil.this.notifyMessage(largeBitmap, messages, contactInfo, newMsgInfo);
            }
        });
    }

    private void notifyMessage(Bitmap header, String[] messages, NotifyContactInfo contactInfo, NewMessageInfo newMsgInfo) {
        this.isCurrentTalker = false;
        if (!newMsgInfo.isDisturb) {
            if (!NotifyUtils.isAppOnForeground(this.mContext)) {
                this.addMediaNotification(this.mContext);
                this.showNotification(contactInfo, newMsgInfo, header, messages);
            } else {
                String currentActivityName = NotifyUtils.getCurrentActivityName(this.mContext);
                if (currentActivityName == null) {
                    this.addMediaNotification(this.mContext);
                    this.showNotification(contactInfo, newMsgInfo, header, messages);
                } else if (NotifyUtils.isScreenOffOrLock(this.mContext)) {
                    this.addMediaNotification(this.mContext);
                    this.showNotification(contactInfo, newMsgInfo, header, messages);
                } else if (currentActivityName.equals(NOT_NOTIFY_ACTIVITY) && !TextUtils.isEmpty((CharSequence)this.mCurTalkAccount) && contactInfo != null && this.mCurTalkAccount.equals(contactInfo.account)) {
                    this.isCurrentTalker = true;
                    this.addMediaNotification(this.mContext);
                } else if (currentActivityName.equals(NOT_NOTIFY_ACTIVITY) && !TextUtils.isEmpty((CharSequence)this.mCurTalkAccount) && contactInfo != null && !this.mCurTalkAccount.equals(contactInfo.account)) {
                    this.addMediaNotification(this.mContext);
                } else {
                    this.addMediaNotification(this.mContext);
                }
            }
        }
    }

    private NotificationCompat.Builder getNotificationCompat() {
        return new NotificationCompat.Builder(this.mContext, this.CHANNEL_ID);
    }

    private void showNotification(NotifyContactInfo contactInfo, NewMessageInfo newMsgInfo, Bitmap header, String[] messages) {
        String notifyMsg = messages[1];
        String notifyTitleMsg = messages[0];
        if (notifyMsg == null || TextUtils.isEmpty((CharSequence)notifyTitleMsg)) {
            return;
        }
        NotificationCompat.Builder notificationBuilder = this.getNotificationCompat();
        NotificationIntent intent = new NotificationIntent("ChatDetailActivity");
        Bundle bundle = new Bundle();
        bundle.putInt("pageIndex", 0);
        String packageName = this.mContext.getPackageName();
        if (newMsgInfo.talkType == 1 && this.singleNotifyList.size() > 0) {
            if (this.singleNotifyList.size() == 1) {
                bundle.putString("targetActivity", packageName + "." + NotifyConstant.NOT_NOTIFY_ACTIVITY);
            } else {
                bundle.putString("targetActivity", packageName + "." + "action.xjda.im.uikit.mainchat");
            }
        }
        if (newMsgInfo.talkType == 2 && this.groupNotifyList.size() > 0) {
            if (this.groupNotifyList.size() == 1) {
                bundle.putString("targetActivity", packageName + "." + NotifyConstant.NOT_NOTIFY_ACTIVITY);
            } else {
                bundle.putString("targetActivity", packageName + "." + "action.xjda.im.uikit.mainchat");
            }
        }
        String notificationTag = newMsgInfo.talkType == 2 ? "groupTalk" : "singleTalk";
        bundle.putString("talkerId", contactInfo.account);
        bundle.putInt("talkType", newMsgInfo.talkType);
        intent.setPackage(packageName);
        intent.putExtras(bundle);
        int requestId = 0;
        PendingIntent pendingIntent = intent.buildPendingIntent(this.mContext, (int)System.currentTimeMillis());
        notificationBuilder.setContentIntent(pendingIntent);
        int res = R.mipmap.ic_launcher;
        if (Build.VERSION.SDK_INT >= 26) {
            notificationBuilder.setContentText((CharSequence)notifyMsg).setContentTitle((CharSequence)notifyTitleMsg).setSmallIcon(res).setTicker((CharSequence)notifyMsg).setLargeIcon(header).setSound(null).setContentIntent(pendingIntent);
        } else {
            notificationBuilder.setContentText((CharSequence)notifyMsg).setContentTitle((CharSequence)notifyTitleMsg).setSmallIcon(res).setTicker((CharSequence)notifyMsg).setLargeIcon(header).setContentIntent(pendingIntent);
        }
        Notification notification = notificationBuilder.build();
        notification.ledARGB = -16711936;
        notification.ledOnMS = 1;
        notification.ledOffMS = 0;
        notification.when = contactInfo.time;
        notification.flags |= 1;
        notification.flags |= 0x10;
        this.notifyManager.notify(notificationTag, requestId, notification);
    }

    private void addMediaNotification(final Context context) {
        long bootTime = SystemClock.elapsedRealtime();
        long time = bootTime - this.addPushTime;
        if (time < 3000L) {
            LogUtil.d("Last remind time is " + time);
            return;
        }
        this.addPushTime = SystemClock.elapsedRealtime();
        this.diskDataStore.loadSettingParams(new Subscriber<SettingParam>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
            }

            public void onNext(SettingParam settingParam) {
                if (settingParam == null) {
                    LogUtil.w("Load setting param is null.");
                    return;
                }
                boolean sysShake = false;
                boolean sysVoice = false;
                AudioManager audioService = (AudioManager)context.getSystemService("audio");
                int mode = audioService.getRingerMode();
                if (mode != 0) {
                    if (mode == 1) {
                        sysShake = true;
                        sysVoice = false;
                    } else {
                        sysShake = true;
                        sysVoice = true;
                    }
                }
                RemindParam remind = settingParam.getRemind();
                DisturbParam disturb = settingParam.getDisturb();
                if (Build.VERSION.SDK_INT < 26) {
                    if (!remind.isOpen()) {
                        LogUtil.d("Remind is close.");
                    } else if (disturb != null && disturb.isOpen() && NotificationUtil.this.isInNoDisturb(disturb.getStartTime(), disturb.getEndTime())) {
                        LogUtil.d("disturb is open.");
                    } else {
                        if (sysVoice && remind.isVoice()) {
                            NotificationUtil.this.remindByVoice(context);
                        }
                        if (sysShake && remind.isVibrate()) {
                            NotificationUtil.this.remindByVibrate(context);
                        }
                    }
                }
            }
        });
    }

    private void remindByVoice(Context context) {
        try {
            this.player = MediaPlayer.create((Context)context, (Uri)RingtoneManager.getActualDefaultRingtoneUri((Context)context, (int)2));
            this.player.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

                public void onCompletion(MediaPlayer mediaPlayer) {
                    mediaPlayer.stop();
                    mediaPlayer.release();
                    mediaPlayer = null;
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (this.player != null && !this.player.isPlaying() && !this.isCurrentTalker) {
                this.player.start();
            }
        }
    }

    private void remindByVibrate(Context context) {
        Vibrator vibrator = (Vibrator)context.getSystemService("vibrator");
        if (vibrator != null) {
            vibrator.vibrate(300L);
        }
    }

    private List<NotificationBean> addNotificationBean(NotifyContactInfo contactInfo, NewMessageInfo newMsgInfo) {
        String account = contactInfo.account;
        String imgUrl = contactInfo.imgUrl;
        String accountName = contactInfo.name;
        String talkId = newMsgInfo.talkId;
        int containIndex = -1;
        ArrayList<NotificationBean> tempList = newMsgInfo.talkType == 2 ? this.groupNotifyList : this.singleNotifyList;
        int size = tempList.size();
        for (int i = 0; i < size; ++i) {
            if (!((NotificationBean)tempList.get(i)).equals(account)) continue;
            containIndex = i;
            break;
        }
        if (containIndex > -1) {
            NotificationBean notificationBean = (NotificationBean)tempList.get(containIndex);
            if (notificationBean != null) {
                int preMsgCount = notificationBean.msgCount < 0 ? 0 : notificationBean.msgCount;
                notificationBean.accountName = accountName;
                notificationBean.msgCount = preMsgCount + newMsgInfo.newMsgCount;
            } else {
                notificationBean = new NotificationBean(account, accountName, newMsgInfo.newMsgCount, imgUrl);
            }
            tempList.remove(containIndex);
            notificationBean.imageUrl = imgUrl;
            tempList.add(0, notificationBean);
        } else {
            NotificationBean notificationBean = new NotificationBean(account, accountName, newMsgInfo.newMsgCount, imgUrl);
            tempList.add(0, notificationBean);
        }
        return tempList;
    }

    public void clearPNNotification() {
        this.notifyManager.cancel("singleTalk", 0);
        this.notifyManager.cancel("groupTalk", 0);
        this.singleNotifyList.clear();
        this.groupNotifyList.clear();
    }

    public boolean isInNoDisturb(long startTime, long endTime) {
        Calendar calendar = Calendar.getInstance();
        int nowHour = calendar.get(11);
        int nowMin = calendar.get(12);
        int startHour = (int)(startTime / 3600L);
        int startMin = (int)((startTime - (long)(startHour * 3600)) / 60L);
        int endHour = (int)(endTime / 3600L);
        int endMin = (int)((endTime - (long)(endHour * 3600)) / 60L);
        int tempHour = 0;
        boolean flag = false;
        if (startHour > endHour) {
            tempHour = startHour;
            startHour = endHour;
            endHour = tempHour;
            flag = true;
        }
        if (nowHour < startHour || nowHour > endHour) {
            return flag;
        }
        if (nowHour == startHour && nowHour < endHour) {
            if (flag) {
                return nowMin <= startMin;
            }
            return nowMin > startMin;
        }
        if (nowHour == endHour && nowHour > startHour) {
            if (flag) {
                return nowMin >= endMin;
            }
            return nowMin < endMin;
        }
        if (nowHour > startHour && nowHour < endHour) {
            return !flag;
        }
        if (nowHour == startHour && nowHour == endHour) {
            return startMin < nowMin && nowMin < endMin;
        }
        return false;
    }

    public class NotificationIntent
    extends Intent {
        public NotificationIntent(String targetName) {
            super("notification");
            this.addFlags(0x10000000);
            this.putExtra("targetActivity", targetName);
        }

        public PendingIntent buildPendingIntent(@NonNull Context context, int reqCode) {
            return PendingIntent.getBroadcast((Context)context, (int)reqCode, (Intent)this, (int)0x8000000);
        }
    }

    public class NotificationBean {
        public String account;
        public String accountName;
        public int msgCount;
        public String imageUrl;

        public NotificationBean(String account, String accountName, int msgCount, String imageUrl) {
            this.account = account;
            this.accountName = accountName;
            this.msgCount = msgCount;
            this.imageUrl = imageUrl;
        }

        public boolean equals(Object o) {
            if (this.account == null || o == null) {
                return false;
            }
            if (o instanceof NotificationBean) {
                NotificationBean notificationBean = (NotificationBean)o;
                if (notificationBean.account.equals(this.account)) {
                    return true;
                }
            } else {
                String tempId;
                return o instanceof String && (tempId = (String)o).equals(this.account);
            }
            return super.equals(o);
        }
    }

    public class NewMessageInfo {
        public String talkId;
        public int newMsgCount;
        public boolean isDisturb;
        public int talkType;

        public NewMessageInfo(String talkId, int newMsgCount, int talkType, boolean isDisturb) {
            this.talkId = talkId;
            this.talkType = talkType;
            this.newMsgCount = newMsgCount;
            this.isDisturb = isDisturb;
        }
    }

    public class NotifyContactInfo {
        public String account;
        public String imgUrl;
        public String name;
        public long time;

        public NotifyContactInfo(String account, String imgUrl, String name, long time) {
            this.account = account;
            this.imgUrl = imgUrl;
            this.name = name;
            this.time = time;
        }
    }

    private static class SingletonInstance {
        private static final NotificationUtil mInstance = new NotificationUtil();

        private SingletonInstance() {
        }
    }
}

