/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.ui.view;

import android.support.annotation.NonNull;
import android.view.View;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.xdja.im.common.utils.FileSizeUtils;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.core.model.message.file.NormalFileInfo;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.ui.presenter.ChatListAdapterPresenter;
import com.xdja.im.uikit.ui.view.BaseReceiveItem;
import com.xdja.im.uikit.utils.file.FileUtils;
import com.xdja.im.uikit.utils.file.TranslateInfoUtil;
import com.xdja.im.uikit.utils.log.LogUtil;

public class ViewRecvFileItem
extends BaseReceiveItem {
    private ImageView mFileIconImg;
    private TextView mFileNameTv;
    private TextView mFileSizeTv;
    private ProgressBar mLoadingPBar;
    private ImageView mDownloadStateImg;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_item_chat_receive_file;
    }

    @Override
    protected void injectView() {
        super.injectView();
        this.mFileIconImg = (ImageView)this.findViewById(R.id.img_file_flag);
        this.mFileNameTv = (TextView)this.findViewById(R.id.tv_file_name);
        this.mFileSizeTv = (TextView)this.findViewById(R.id.tv_file_size);
        this.mLoadingPBar = (ProgressBar)this.findViewById(R.id.pbar_file_progress);
        this.mDownloadStateImg = (ImageView)this.findViewById(R.id.img_download_state);
        this.mContentLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                NormalFileInfo fileInfo = (NormalFileInfo)((TalkMessageBean)ViewRecvFileItem.this.dataSource).getFileInfo();
                if (fileInfo == null) {
                    LogUtil.e("ERROR: start open file, but file info is null.");
                    return;
                }
                if (fileInfo.getFileState() == 2) {
                    ((ChatListAdapterPresenter)ViewRecvFileItem.this.getPresenter()).openNormalFile((TalkMessageBean)ViewRecvFileItem.this.dataSource);
                } else {
                    ((ChatListAdapterPresenter)ViewRecvFileItem.this.getPresenter()).loadNormalFile((TalkMessageBean)ViewRecvFileItem.this.dataSource);
                }
            }
        });
    }

    @Override
    public void onViewReused() {
        super.onViewReused();
        this.mFileIconImg.setImageBitmap(null);
        this.mFileNameTv.setText((CharSequence)"");
        this.mFileSizeTv.setText((CharSequence)"");
        this.mLoadingPBar.setProgress(0);
    }

    @Override
    public void bindDataSource(int position, @NonNull TalkMessageBean dataSource) {
        super.bindDataSource(position, dataSource);
        NormalFileInfo fileInfo = (NormalFileInfo)dataSource.getFileInfo();
        if (fileInfo == null) {
            LogUtil.e("ERROR: receive file info is null error.");
            return;
        }
        if (fileInfo.getFileState() != 2 && fileInfo.getFileState() != 1 && fileInfo.getFileState() != 5) {
            this.mDownloadStateImg.setImageResource(this.getStateImage(fileInfo));
            this.mLoadingPBar.setVisibility(0);
            this.mLoadingPBar.setProgress((int)((float)this.getTranslateSize(fileInfo) * 100.0f / (float)fileInfo.getFileSize()));
        } else {
            if (fileInfo.getFileState() == 5) {
                this.mDownloadStateImg.setImageResource(this.getStateImage(fileInfo));
            } else {
                this.mDownloadStateImg.setImageDrawable(null);
            }
            this.mLoadingPBar.setVisibility(8);
        }
        this.mFileIconImg.setImageResource(FileUtils.getIconWithSuffix(fileInfo.getFilePath()));
        this.mFileNameTv.setText((CharSequence)fileInfo.getFileName());
        this.mFileSizeTv.setText((CharSequence)FileSizeUtils.formatFileSize(fileInfo.getFileSize()));
    }

    private long getTranslateSize(NormalFileInfo fileInfo) {
        return Math.max(TranslateInfoUtil.getTranslateSize(fileInfo.getTalkMessageId()), fileInfo.getTranslateSize());
    }

    private int getStateImage(FileInfo fileInfo) {
        int res = 0;
        if (fileInfo.getFileState() == 3) {
            res = R.mipmap.im_uikit_ic_download_normal;
        } else if (fileInfo.getFileState() == 5) {
            res = R.mipmap.im_uikit_ic_again_normal;
        } else if (fileInfo.getFileState() == 4) {
            res = R.mipmap.im_uikit_ic_suspend_normal;
        }
        return res;
    }
}

