/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.ui.view;

import android.app.Activity;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.lib.share.model.WebPageInfo;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.ui.presenter.ChatListAdapterPresenter;
import com.xdja.im.uikit.ui.view.BaseReceiveItem;
import com.xdja.im.uikit.view.CircleImageView;

public class ViewRecvWebItem
extends BaseReceiveItem {
    private static final String TAG = "ViewSendWebItem";
    private TextView recvWebTitle;
    private TextView recvWebDes;
    private ImageView recvWebThumb;
    private CircleImageView ivHeader;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_item_chat_rec_web;
    }

    @Override
    protected void injectView() {
        super.injectView();
        View view = this.getView();
        this.recvWebTitle = (TextView)view.findViewById(R.id.web_title);
        this.recvWebDes = (TextView)view.findViewById(R.id.web_des);
        this.recvWebThumb = (ImageView)view.findViewById(R.id.web_thumb);
        this.mContentLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ((ChatListAdapterPresenter)ViewRecvWebItem.this.getPresenter()).clickWebMessage((TalkMessageBean)ViewRecvWebItem.this.dataSource);
            }
        });
    }

    @Override
    public void bindDataSource(int position, @NonNull TalkMessageBean dataSource) {
        super.bindDataSource(position, dataSource);
        this.initView();
    }

    private void initView() {
        WebPageInfo webPageInfo = ((TalkMessageBean)this.dataSource).getWebPageInfo();
        String webUri = webPageInfo.getWebUri();
        String description = webPageInfo.getDescription();
        String source = webPageInfo.getSource();
        String title = webPageInfo.getTitle();
        Glide.with((Activity)this.getActivity()).load(webPageInfo.getFilePath()).placeholder(R.drawable.default_web_word).error(R.drawable.default_web_word).into(this.recvWebThumb);
        this.recvWebTitle.setText((CharSequence)title);
        this.recvWebDes.setText((CharSequence)description);
    }
}

