/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.ui.view;

import android.app.Activity;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.ImageFileInfo;
import com.xdja.im.lib.filemanage.util.HistoryFileUtils;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.ui.presenter.ChatListAdapterPresenter;
import com.xdja.im.uikit.ui.view.BaseSendItem;
import com.xdja.im.uikit.utils.file.FileUtils;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.im.uikit.view.ChatImageView;

public class ViewSendImageItem
extends BaseSendItem {
    private ChatImageView mChatImage;
    private ImageView mGifImageView;
    private ImageView mBombFlagImg;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_item_chat_send_image;
    }

    @Override
    protected void injectView() {
        super.injectView();
        this.mChatImage = (ChatImageView)this.findViewById(R.id.img_send_image);
        this.mGifImageView = (ImageView)this.findViewById(R.id.img_send_gif_image);
        this.mBombFlagImg = (ImageView)this.findViewById(R.id.img_bomb_flag);
        this.mContentLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ((ChatListAdapterPresenter)ViewSendImageItem.this.getPresenter()).previewImage((TalkMessageBean)ViewSendImageItem.this.dataSource);
            }
        });
    }

    @Override
    public void bindDataSource(int position, @NonNull TalkMessageBean dataSource) {
        super.bindDataSource(position, dataSource);
        ImageFileInfo fileInfo = (ImageFileInfo)dataSource.getFileInfo();
        if (fileInfo == null) {
            LogUtil.e("load image, but file info is null");
            this.mChatImage.setError(R.mipmap.im_uikit_pic_failed);
            return;
        }
        this.loadImage(fileInfo, dataSource);
        if (dataSource.isBomb()) {
            this.mBombFlagImg.setVisibility(0);
        }
    }

    private void loadImage(ImageFileInfo imageFileInfo, TalkMessageBean dataSource) {
        if (FileUtils.isFileExists(imageFileInfo.getFilePath())) {
            this.loadImageUrl(imageFileInfo, dataSource);
        } else {
            LogUtil.w("file is not exit.");
            this.mChatImage.setError(R.mipmap.im_uikit_pic_default);
        }
    }

    private void loadImageUrl(ImageFileInfo imageFileInfo, TalkMessageBean dataSource) {
        String suffix = imageFileInfo.getSuffix();
        if (imageFileInfo != null && "gif".equalsIgnoreCase(suffix) && !TextUtils.isEmpty((CharSequence)imageFileInfo.getFilePath())) {
            String urlGif = imageFileInfo.getFilePath();
            long fileSize = imageFileInfo.getFileSize();
            this.mChatImage.setVisibility(8);
            this.mGifImageView.setVisibility(0);
            if (HistoryFileUtils.isFileExist(urlGif)) {
                Glide.with((Activity)this.getActivity()).load(urlGif).placeholder(R.mipmap.im_uikit_pic_default).diskCacheStrategy(DiskCacheStrategy.SOURCE).into(this.mGifImageView);
            }
        } else {
            this.mChatImage.setVisibility(0);
            this.mGifImageView.setVisibility(8);
            this.mChatImage.loadImage(imageFileInfo.getFilePath());
        }
    }
}

