/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.ui.view;

import android.app.Activity;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.lib.share.model.WebPageInfo;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.ui.presenter.ChatListAdapterPresenter;
import com.xdja.im.uikit.ui.view.BaseSendItem;
import com.xdja.im.uikit.view.CircleImageView;

public class ViewSendWebItem
extends BaseSendItem {
    private static final String TAG = "ViewSendWebItem";
    private TextView sendWebTitle;
    private TextView sendWebDes;
    private ImageView sendWebThumb;
    private CircleImageView ivHeader;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_item_chat_send_web;
    }

    @Override
    protected void injectView() {
        super.injectView();
        View view = this.getView();
        this.sendWebTitle = (TextView)view.findViewById(R.id.web_title);
        this.sendWebDes = (TextView)view.findViewById(R.id.web_des);
        this.sendWebThumb = (ImageView)view.findViewById(R.id.web_thumb);
        this.mContentLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ((ChatListAdapterPresenter)ViewSendWebItem.this.getPresenter()).clickWebMessage((TalkMessageBean)ViewSendWebItem.this.dataSource);
            }
        });
    }

    @Override
    public void bindDataSource(int position, @NonNull TalkMessageBean dataSource) {
        super.bindDataSource(position, dataSource);
        this.initView();
    }

    private void initView() {
        WebPageInfo webPageInfo = ((TalkMessageBean)this.dataSource).getWebPageInfo();
        String webUri = webPageInfo.getWebUri();
        String description = webPageInfo.getDescription();
        String source = webPageInfo.getSource();
        String title = webPageInfo.getTitle();
        this.sendWebTitle.setText((CharSequence)title);
        this.sendWebDes.setText((CharSequence)description);
        Glide.with((Activity)this.getActivity()).load(webPageInfo.getFilePath()).placeholder(R.drawable.default_web_word).error(R.drawable.default_web_word).into(this.sendWebThumb);
    }
}

