/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.http.impl.conn;

import com.xdja.http.HttpResponse;
import com.xdja.http.HttpResponseFactory;
import com.xdja.http.annotation.Immutable;
import com.xdja.http.config.MessageConstraints;
import com.xdja.http.impl.DefaultHttpResponseFactory;
import com.xdja.http.impl.conn.DefaultHttpResponseParser;
import com.xdja.http.io.HttpMessageParser;
import com.xdja.http.io.HttpMessageParserFactory;
import com.xdja.http.io.SessionInputBuffer;
import com.xdja.http.message.BasicLineParser;
import com.xdja.http.message.LineParser;

@Immutable
public class DefaultHttpResponseParserFactory
implements HttpMessageParserFactory<HttpResponse> {
    public static final DefaultHttpResponseParserFactory INSTANCE = new DefaultHttpResponseParserFactory();
    private final LineParser lineParser;
    private final HttpResponseFactory responseFactory;

    public DefaultHttpResponseParserFactory(LineParser lineParser, HttpResponseFactory responseFactory) {
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.responseFactory = responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE;
    }

    public DefaultHttpResponseParserFactory(HttpResponseFactory responseFactory) {
        this(null, responseFactory);
    }

    public DefaultHttpResponseParserFactory() {
        this(null, null);
    }

    @Override
    public HttpMessageParser<HttpResponse> create(SessionInputBuffer buffer, MessageConstraints constraints) {
        return new DefaultHttpResponseParser(buffer, this.lineParser, this.responseFactory, constraints);
    }
}

