/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.http.impl.io;

import com.xdja.http.HttpException;
import com.xdja.http.HttpResponse;
import com.xdja.http.HttpResponseFactory;
import com.xdja.http.NoHttpResponseException;
import com.xdja.http.ParseException;
import com.xdja.http.StatusLine;
import com.xdja.http.annotation.NotThreadSafe;
import com.xdja.http.config.MessageConstraints;
import com.xdja.http.impl.DefaultHttpResponseFactory;
import com.xdja.http.impl.io.AbstractMessageParser;
import com.xdja.http.io.SessionInputBuffer;
import com.xdja.http.message.LineParser;
import com.xdja.http.message.ParserCursor;
import com.xdja.http.params.HttpParams;
import com.xdja.http.util.Args;
import com.xdja.http.util.CharArrayBuffer;
import java.io.IOException;

@NotThreadSafe
public class DefaultHttpResponseParser
extends AbstractMessageParser<HttpResponse> {
    private final HttpResponseFactory responseFactory;
    private final CharArrayBuffer lineBuf;

    @Deprecated
    public DefaultHttpResponseParser(SessionInputBuffer buffer, LineParser lineParser, HttpResponseFactory responseFactory, HttpParams params) {
        super(buffer, lineParser, params);
        this.responseFactory = Args.notNull(responseFactory, "Response factory");
        this.lineBuf = new CharArrayBuffer(128);
    }

    public DefaultHttpResponseParser(SessionInputBuffer buffer, LineParser lineParser, HttpResponseFactory responseFactory, MessageConstraints constraints) {
        super(buffer, lineParser, constraints);
        this.responseFactory = responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE;
        this.lineBuf = new CharArrayBuffer(128);
    }

    public DefaultHttpResponseParser(SessionInputBuffer buffer, MessageConstraints constraints) {
        this(buffer, null, null, constraints);
    }

    public DefaultHttpResponseParser(SessionInputBuffer buffer) {
        this(buffer, null, null, MessageConstraints.DEFAULT);
    }

    @Override
    protected HttpResponse parseHead(SessionInputBuffer sessionBuffer) throws IOException, HttpException, ParseException {
        this.lineBuf.clear();
        int i = sessionBuffer.readLine(this.lineBuf);
        if (i == -1) {
            throw new NoHttpResponseException("The target server failed to respond");
        }
        ParserCursor cursor = new ParserCursor(0, this.lineBuf.length());
        StatusLine statusline = this.lineParser.parseStatusLine(this.lineBuf, cursor);
        return this.responseFactory.newHttpResponse(statusline, null);
    }
}

