/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.db.builder;

import com.xdja.imsdk.constant.ImSdkFileConstant;
import com.xdja.imsdk.db.helper.SqlBuilder;
import java.util.List;

public class MsgEntryBuilder {
    public static final String TABLE_NAME = "msg_entry";
    public static final String ID = "_id";
    public static final String SERVER_ID = "SERVER_ID";
    public static final String SENDER = "SENDER";
    public static final String RECEIVER = "RECEIVER";
    public static final String CARD_ID = "CARD_ID";
    public static final String TYPE = "TYPE";
    public static final String CONTENT = "CONTENT";
    public static final String STATE = "STATE";
    public static final String SESSION_FLAG = "SESSION_FLAG";
    public static final String ATTR = "ATTR";
    public static final String LIFE_TIME = "LIFE_TIME";
    public static final String CREATE_TIME = "CREATE_TIME";
    public static final String SENT_TIME = "SENT_TIME";
    public static final String SORT_TIME = "SORT_TIME";
    public static final String MSG_EXTRA = "MSG_EXTRA";
    public static final String EXTRA_STATE = "EXTRA_STATE";
    private static final String[] ALL_COLUMNS = new String[]{"_id", "SERVER_ID", "SENDER", "RECEIVER", "CARD_ID", "TYPE", "CONTENT", "STATE", "SESSION_FLAG", "ATTR", "LIFE_TIME", "CREATE_TIME", "SENT_TIME", "SORT_TIME", "MSG_EXTRA", "EXTRA_STATE"};
    public static final String JOIN_ID = "JOIN_ID";
    public static final String M_TAG = "M_TAG";
    public static final String SQL_CREATE_TABLE_MSG = "CREATE TABLE msg_entry (_id INTEGER PRIMARY KEY AUTOINCREMENT,SERVER_ID INTEGER UNIQUE,SENDER TEXT,RECEIVER TEXT,CARD_ID TEXT,TYPE INTEGER DEFAULT 0,CONTENT TEXT,STATE INTEGER DEFAULT 0,SESSION_FLAG TEXT,ATTR INTEGER DEFAULT 0,LIFE_TIME INTEGER DEFAULT 0,CREATE_TIME INTEGER DEFAULT 0,SENT_TIME INTEGER DEFAULT 0,SORT_TIME INTEGER DEFAULT 0,MSG_EXTRA TEXT,EXTRA_STATE INTEGER DEFAULT 0)";
    public static final String SQL_CREATE_INDEX_ON_ID = "CREATE INDEX msg_id_index ON msg_entry(_id)";
    public static final String SQL_CREATE_INDEX_ON_SERVER = "CREATE INDEX msg_server_index ON msg_entry(SERVER_ID)";
    public static final String SQL_CREATE_INDEX_ON_TAG = "CREATE INDEX msg_tag_index ON msg_entry(SESSION_FLAG)";
    public static final String SQL_CREATE_INDEX_ON_SENDER = "CREATE INDEX msg_sender_index ON msg_entry(SENDER)";
    public static final String SQL_CREATE_INDEX_ON_RECEIVER = "CREATE INDEX msg_receiver_index ON msg_entry(RECEIVER)";
    public static final String SQL_CREATE_INDEX_ON_CREATE = "CREATE INDEX msg_create_index ON msg_entry(CREATE_TIME)";
    public static final String SESSION_UPDATE_REMIND_ON_INSERT_TRIGGER = "CREATE TRIGGER session_update_remind_on_insert_trigger  AFTER INSERT ON msg_entry BEGIN  UPDATE session_entry SET LAST_TIME = (CASE WHEN LAST_TIME < new.SORT_TIME THEN new.SORT_TIME ELSE LAST_TIME END), LAST_MSG = (CASE WHEN LAST_TIME < new.SORT_TIME THEN new._id ELSE LAST_MSG END), REMINDED = (CASE WHEN new.STATE > 0 AND (new.ATTR & 1 ) = 1 AND (new.TYPE & 8192) <> 8192 THEN REMINDED + 1 ELSE REMINDED END), STRICTLY = (CASE WHEN (new.ATTR & 1 ) = 1 AND (new.TYPE & 8192) = 8192 THEN STRICTLY + 1 ELSE STRICTLY END) WHERE (new.TYPE & 16) <> 16 AND SESSION_FLAG = new.SESSION_FLAG; END;";
    public static final String MSG_INSERT_DELETED_ON_DELETE_TRIGGER = "CREATE TRIGGER msg_insert_deleted_on_delete_trigger  BEFORE DELETE ON msg_entry WHEN (old.TYPE & 16) <> 16 AND old.SERVER_ID > 0  BEGIN  INSERT INTO deleted_msg (MSG_ID, SERVER_ID) VALUES(old._id, old.SERVER_ID); END; ";
    public static final String FILE_MSG_DELETE_ON_DELETE_TRIGGER = "CREATE TRIGGER file_msg_delete_on_delete_trigger  BEFORE DELETE ON msg_entry BEGIN  DELETE FROM file_msg WHERE MSG_ID = old._id; DELETE FROM hd_thumb_file WHERE HD_MSG_ID = old._id; DELETE FROM raw_file WHERE RAW_MSG_ID = old._id; END; ";
    public static final String FILE_MSG_DELETE_ON_UPDATE_TRIGGER = "CREATE TRIGGER file_msg_delete_on_update_trigger  AFTER UPDATE ON msg_entry WHEN (new.TYPE & 2) = 2 AND new.STATE = 4 AND new.ATTR & 1 = 1 BEGIN  DELETE FROM file_msg WHERE MSG_ID = new._id; DELETE FROM hd_thumb_file WHERE HD_MSG_ID = old._id; DELETE FROM raw_file WHERE RAW_MSG_ID = old._id; END; ";

    public static String insertSql() {
        return SqlBuilder.insertSql("INSERT OR IGNORE INTO  ", TABLE_NAME, ALL_COLUMNS);
    }

    public static String delSql(List<Long> ids) {
        return SqlBuilder.deleteSql(TABLE_NAME, ID, ids);
    }

    public static String delSql(String tag) {
        return SqlBuilder.deleteSql(TABLE_NAME, SESSION_FLAG, tag);
    }

    public static String delDesStrictly() {
        StringBuilder builder = new StringBuilder("DELETE FROM ");
        builder.append(TABLE_NAME).append(" WHERE (").append(TYPE).append(" & ");
        builder.append(8192).append(") = ").append(8192);
        builder.append(" AND ").append(TABLE_NAME).append(".");
        builder.append(STATE).append(" = ").append(4).append(" AND (");
        builder.append(TABLE_NAME).append(".");
        builder.append(ATTR).append(" & ").append(1);
        builder.append(") = ").append(1).append(";");
        return builder.toString();
    }

    public static String updateStateSql() {
        return "UPDATE msg_entry SET STATE = ? WHERE SERVER_ID =  ? AND STATE < ?";
    }

    public static String updateMsgStateSql() {
        return "UPDATE msg_entry SET STATE = ?, CONTENT = ? WHERE _id =  ?";
    }

    public static String updateMsgStateReadSql() {
        return "UPDATE msg_entry SET STATE = ?  WHERE _id =  ?";
    }

    private static String getAsId(String name, String as) {
        StringBuilder builder = new StringBuilder(name);
        builder.append(".").append(ID).append(" AS ").append(as);
        return builder.toString();
    }

    private static StringBuilder getAll() {
        StringBuilder builder = new StringBuilder("SELECT ");
        builder.append(MsgEntryBuilder.getAsId(TABLE_NAME, JOIN_ID)).append(", ");
        builder.append(MsgEntryBuilder.getAsId("file_msg", "F_JOIN_ID")).append(", ");
        builder.append(MsgEntryBuilder.getAsId("hd_thumb_file", "HD_JOIN_ID")).append(", ");
        builder.append(MsgEntryBuilder.getAsId("raw_file", "RAW_JOIN_ID")).append(", ");
        builder.append(TABLE_NAME).append(".*, ").append("file_msg");
        builder.append(".*, ").append("hd_thumb_file");
        builder.append(".*, ").append("raw_file");
        builder.append(".* FROM ").append(TABLE_NAME).append(" LEFT JOIN ");
        builder.append("file_msg").append(" ON ").append(TABLE_NAME);
        builder.append(".").append(ID).append(" = ").append("file_msg");
        builder.append(".").append("MSG_ID").append(" LEFT JOIN ");
        builder.append("hd_thumb_file").append(" ON ").append(TABLE_NAME);
        builder.append(".").append(ID).append(" = ").append("hd_thumb_file");
        builder.append(".").append("HD_MSG_ID").append(" LEFT JOIN ");
        builder.append("raw_file").append(" ON ").append(TABLE_NAME);
        builder.append(".").append(ID).append(" = ").append("raw_file");
        builder.append(".").append("RAW_MSG_ID");
        return builder;
    }

    private static StringBuilder getNon() {
        StringBuilder builder = new StringBuilder("SELECT ");
        builder.append(TABLE_NAME).append(".*");
        builder.append(" FROM ").append(TABLE_NAME);
        return builder;
    }

    private static StringBuilder getShow() {
        StringBuilder builder = new StringBuilder("SELECT ");
        builder.append(MsgEntryBuilder.getAsId(TABLE_NAME, JOIN_ID)).append(", ");
        builder.append(MsgEntryBuilder.getAsId("file_msg", "F_JOIN_ID")).append(", ");
        builder.append(TABLE_NAME).append(".*, ").append("file_msg");
        builder.append(".* FROM ").append(TABLE_NAME).append(" LEFT JOIN ");
        builder.append("file_msg").append(" ON ").append(TABLE_NAME);
        builder.append(".").append(ID).append(" = ").append("file_msg");
        builder.append(".").append("MSG_ID");
        return builder;
    }

    private static StringBuilder getRaw() {
        StringBuilder builder = new StringBuilder("SELECT ");
        builder.append(MsgEntryBuilder.getAsId(TABLE_NAME, JOIN_ID)).append(", ");
        builder.append(MsgEntryBuilder.getAsId("file_msg", "F_JOIN_ID")).append(", ");
        builder.append(MsgEntryBuilder.getAsId("raw_file", "RAW_JOIN_ID")).append(", ");
        builder.append(TABLE_NAME).append(".*, ").append("file_msg");
        builder.append(".*, ").append("raw_file");
        builder.append(".* FROM ").append(TABLE_NAME).append(" LEFT JOIN ");
        builder.append("file_msg").append(" ON ").append(TABLE_NAME);
        builder.append(".").append(ID).append(" = ").append("file_msg");
        builder.append(".").append("MSG_ID").append(" LEFT JOIN ");
        builder.append("raw_file").append(" ON ").append(TABLE_NAME);
        builder.append(".").append(ID).append(" = ").append("raw_file");
        builder.append(".").append("RAW_MSG_ID");
        return builder;
    }

    public static String queryShow(String tag, long begin, int size, boolean strictly) {
        StringBuilder builder = MsgEntryBuilder.getShow();
        String whereAll = strictly ? " WHERE msg_entry.SESSION_FLAG = '" + tag + "'" + " AND (" + TYPE + " & " + 8192 + ") = " + 8192 + " AND " + STATE + " < " + 4 : " WHERE msg_entry.SESSION_FLAG = '" + tag + "'" + " AND (" + TYPE + " & " + 8192 + ") <> " + 8192;
        if (begin == 0L) {
            builder.append(whereAll).append(SqlBuilder.getOrder(SORT_TIME));
            if (size > 0) {
                builder.append(SqlBuilder.getLimit(Math.abs(size)));
            }
            return builder.toString();
        }
        if (size == 0) {
            builder.append(" WHERE ").append(TABLE_NAME).append(".").append(ID).append(" = ").append(begin);
        } else {
            String whereCompare = " AND msg_entry.SORT_TIME" + (size > 0 ? " < " : " >= ") + "(SELECT " + TABLE_NAME + "." + SORT_TIME + " FROM " + TABLE_NAME + " WHERE " + TABLE_NAME + "." + ID + " = " + begin + ")";
            builder.append(whereAll).append(whereCompare).append(size > 0 ? SqlBuilder.getOrder(SORT_TIME) : SqlBuilder.getOrderDefault(SORT_TIME)).append(SqlBuilder.getLimit(Math.abs(size)));
        }
        if (size < 0) {
            return "SELECT * FROM (" + builder.toString() + ") ORDER BY " + SORT_TIME + " DESC;";
        }
        return builder.toString();
    }

    public static String queryNewMessage(String tag) {
        StringBuilder builder = MsgEntryBuilder.getShow();
        builder.append(" WHERE ").append(TABLE_NAME).append(".").append(STATE);
        builder.append(" = ").append(2).append(" AND ").append(TABLE_NAME).append(".");
        builder.append(ATTR).append(" = ").append(1).append(" AND ");
        builder.append(TABLE_NAME).append(".").append(TYPE).append(" & ").append(8192);
        builder.append(" <> ").append(8192).append(" AND ");
        builder.append(TABLE_NAME).append(".").append(SESSION_FLAG);
        builder.append(" = '").append(tag).append("' ORDER BY ").append(TABLE_NAME);
        builder.append(".").append(SENT_TIME).append(" DESC LIMIT 1 OFFSET (SELECT ");
        builder.append("session_entry").append(".").append("REMINDED");
        builder.append(" FROM ").append("session_entry").append(" WHERE ");
        builder.append("session_entry").append(".").append(SESSION_FLAG);
        builder.append(" = '").append(tag).append("') -1 ;");
        return builder.toString();
    }

    public static String queryImage(String tag, long begin, int size) {
        StringBuilder builder = MsgEntryBuilder.getAll();
        String whereAll = " WHERE msg_entry.SESSION_FLAG = '" + tag + "' AND (" + "file_msg" + "." + "FILE_TYPE" + " = " + 3 + " OR " + "file_msg" + "." + "FILE_TYPE" + " = " + 2 + ") ";
        String whereSingle = " WHERE msg_entry._id = ";
        if (begin == 0L) {
            builder.append(whereAll).append(SqlBuilder.getOrderDefault(SORT_TIME));
            if (size > 0) {
                builder.append(SqlBuilder.getLimit(Math.abs(size)));
            }
        } else if (size == 0) {
            builder.append(whereSingle).append(begin);
        } else {
            String stime = "(SELECT msg_entry.SORT_TIME FROM msg_entry WHERE msg_entry._id = " + begin + ")";
            String whereCompare = " AND msg_entry.SORT_TIME" + (size > 0 ? " < " : " > ") + stime;
            builder.append(whereAll).append(whereCompare).append(SqlBuilder.getOrderDefault(SORT_TIME)).append(SqlBuilder.getLimit(Math.abs(size)));
        }
        return builder.toString();
    }

    public static String queryFile() {
        StringBuilder builder = MsgEntryBuilder.getRaw();
        builder.append(" WHERE (").append("file_msg").append(".").append("FILE_TYPE");
        builder.append(" = ").append(0).append(" OR ");
        builder.append("file_msg").append(".").append("FILE_TYPE");
        builder.append(" = ").append(5).append(" OR ");
        builder.append("file_msg").append(".").append("FILE_TYPE");
        builder.append(" = ").append(6).append(") AND ((");
        builder.append(TABLE_NAME).append(".").append(ATTR).append(" & ").append(1);
        builder.append(" = 0 AND ").append("file_msg").append(".").append("FILE_STATE");
        builder.append(" = ").append(18).append(") OR (").append(TABLE_NAME).append(".");
        builder.append(ATTR).append(" & ").append(1).append(" = ").append(1);
        builder.append(" AND ").append("file_msg").append(".").append("FILE_STATE");
        builder.append(" = ").append(26).append(") OR (").append(TABLE_NAME).append(".");
        builder.append(ATTR).append(" & ").append(1);
        builder.append(" = 0 AND ").append("file_msg").append(".").append("FILE_STATE");
        builder.append(" = ").append(26).append("))");
        builder.append(SqlBuilder.getOrder(SORT_TIME));
        return builder.toString();
    }

    public static String queryCMFile(String tag) {
        StringBuilder builder = MsgEntryBuilder.getAll();
        builder.append(" WHERE ").append(TABLE_NAME).append(".").append(SESSION_FLAG);
        builder.append(" = '").append(tag).append("' AND (");
        builder.append("file_msg").append(".").append("FILE_TYPE");
        builder.append(" = ").append(3).append(" OR ");
        builder.append("file_msg").append(".").append("FILE_TYPE");
        builder.append(" = ").append(2).append(" OR ");
        builder.append("file_msg").append(".").append("FILE_TYPE");
        builder.append(" = ").append(5).append(") ");
        builder.append(SqlBuilder.getOrder(SORT_TIME));
        return builder.toString();
    }

    public static String queryCAFile(String tag) {
        StringBuilder builder = MsgEntryBuilder.getAll();
        builder.append(" WHERE ").append(TABLE_NAME).append(".").append(SESSION_FLAG);
        builder.append(" = '").append(tag).append("' AND (");
        builder.append("file_msg").append(".").append("FILE_TYPE");
        builder.append(" = ").append(3).append(" OR ");
        builder.append("file_msg").append(".").append("FILE_TYPE");
        builder.append(" = ").append(2).append(" OR ");
        builder.append("file_msg").append(".").append("FILE_TYPE");
        builder.append(" = ").append(5).append(" OR ");
        builder.append("file_msg").append(".").append("FILE_TYPE");
        builder.append(" = ").append(6).append(") ");
        builder.append(SqlBuilder.getOrder(SORT_TIME));
        return builder.toString();
    }

    public static String queryCAllFile(String tag) {
        StringBuilder builder = MsgEntryBuilder.getAll();
        builder.append(" WHERE ").append(TABLE_NAME).append(".").append(SESSION_FLAG);
        builder.append(" = '").append(tag).append("' AND (");
        builder.append("file_msg").append(".").append("FILE_TYPE");
        builder.append(" = ").append(3).append(" OR ");
        builder.append("file_msg").append(".").append("FILE_TYPE");
        builder.append(" = ").append(2).append(" OR ");
        builder.append("file_msg").append(".").append("FILE_TYPE");
        builder.append(" = ").append(5).append(" OR ");
        builder.append("file_msg").append(".").append("FILE_TYPE");
        builder.append(" = ").append(0).append(" OR ");
        builder.append("file_msg").append(".").append("FILE_TYPE");
        builder.append(" = ").append(6).append(") ");
        builder.append(SqlBuilder.getOrder(SORT_TIME));
        return builder.toString();
    }

    public static String queryCacheFile() {
        StringBuilder builder = new StringBuilder("SELECT ");
        builder.append("file_msg").append(".").append("ENCRYPT_PATH").append(", ");
        builder.append("file_msg").append(".").append("FILE_PATH").append(", ");
        builder.append("hd_thumb_file").append(".").append("HD_ENCRYPT_PATH").append(", ");
        builder.append("hd_thumb_file").append(".").append("HD_FILE_PATH").append(", ");
        builder.append("raw_file").append(".").append("RAW_ENCRYPT_PATH").append(", ");
        builder.append("raw_file").append(".").append("RAW_FILE_PATH").append(" FROM ");
        builder.append(TABLE_NAME).append(" LEFT JOIN ");
        builder.append("file_msg").append(" ON ").append(TABLE_NAME);
        builder.append(".").append(ID).append(" = ").append("file_msg");
        builder.append(".").append("MSG_ID").append(" LEFT JOIN ");
        builder.append("hd_thumb_file").append(" ON ").append(TABLE_NAME);
        builder.append(".").append(ID).append(" = ").append("hd_thumb_file");
        builder.append(".").append("HD_MSG_ID").append(" LEFT JOIN ");
        builder.append("raw_file").append(" ON ").append(TABLE_NAME);
        builder.append(".").append(ID).append(" = ").append("raw_file");
        builder.append(".").append("RAW_MSG_ID");
        builder.append(" WHERE ").append(TABLE_NAME).append(".").append(TYPE);
        builder.append(" & ").append(2).append(" = ").append(2);
        builder.append(" OR ").append(TABLE_NAME).append(".").append(TYPE);
        builder.append(" & ").append(64).append(" = ").append(64);
        return builder.toString();
    }

    public static String queryOtherFile(String tag) {
        StringBuilder builder = MsgEntryBuilder.getAll();
        builder.append(" WHERE ").append(TABLE_NAME).append(".").append(SESSION_FLAG);
        builder.append(" = '").append(tag).append("' AND ((");
        builder.append(TABLE_NAME).append(".").append(TYPE).append(" & ").append(2);
        builder.append(" = ").append(2).append(" AND ");
        builder.append("file_msg").append(".").append("FILE_TYPE");
        builder.append(" = ").append(0).append(") OR (");
        builder.append(TABLE_NAME).append(".").append(TYPE).append(" = ").append(64).append(" OR ");
        builder.append(TABLE_NAME).append(".").append(TYPE).append(" = ").append(68).append("))");
        builder.append(SqlBuilder.getOrder(SORT_TIME));
        return builder.toString();
    }

    public static String queryFile(String tag) {
        StringBuilder builder = MsgEntryBuilder.getRaw();
        builder.append(" WHERE ").append(TABLE_NAME).append(".").append(SESSION_FLAG);
        builder.append(" = '").append(tag).append("' AND ");
        builder.append("file_msg").append(".").append("FILE_TYPE");
        builder.append(" = ").append(0).append(" AND ((");
        builder.append(TABLE_NAME).append(".").append(ATTR).append(" & ").append(1);
        builder.append(" = 0 AND ").append("file_msg").append(".").append("FILE_STATE");
        builder.append(" = ").append(18).append(") OR (").append(TABLE_NAME).append(".");
        builder.append(ATTR).append(" & ").append(1).append(" = ");
        builder.append(1).append("))");
        builder.append(SqlBuilder.getOrder(SORT_TIME));
        return builder.toString();
    }

    public static String queryAMI(long id) {
        StringBuilder builder = MsgEntryBuilder.getAll();
        builder.append(" WHERE ").append(TABLE_NAME).append(".").append(ID).append(" = ").append(id);
        return builder.toString();
    }

    public static String queryAMAI(long id) {
        StringBuilder builder = MsgEntryBuilder.getAll();
        builder.append(" WHERE ").append(TABLE_NAME).append(".").append(SERVER_ID).append(" = ");
        builder.append(" (SELECT ").append("att_msg").append(".");
        builder.append("MSG_SERVER_ID").append(" FROM ").append("att_msg");
        builder.append(" WHERE ").append("att_msg").append(".").append(ID);
        builder.append(" = ").append(id).append(");");
        return builder.toString();
    }

    public static String queryMI(long id) {
        StringBuilder builder = MsgEntryBuilder.getNon();
        builder.append(" WHERE ").append(TABLE_NAME).append(".").append(ID).append(" = ").append(id);
        return builder.toString();
    }

    public static String queryRM(String account, String where) {
        StringBuilder builder = MsgEntryBuilder.getShow();
        builder.append(where);
        builder.append(" AND ");
        builder.append(TABLE_NAME).append(".").append(STATE);
        builder.append(" = ").append(3).append(" AND (");
        builder.append(TABLE_NAME).append(".").append(TYPE);
        builder.append(" & ").append(8).append(") = ").append(8);
        builder.append(" AND ").append(TABLE_NAME).append(".").append(SENDER);
        builder.append(" <> '").append(account).append("';");
        return builder.toString();
    }

    public static String queryARM(String account) {
        StringBuilder builder = MsgEntryBuilder.getShow();
        builder.append(" WHERE ");
        builder.append(TABLE_NAME).append(".").append(STATE);
        builder.append(" = ").append(3).append(" AND (");
        builder.append(TABLE_NAME).append(".").append(TYPE);
        builder.append(" & ").append(8).append(") = ").append(8);
        builder.append(" AND ").append(TABLE_NAME).append(".").append(SENDER);
        builder.append(" <> '").append(account).append("';");
        return builder.toString();
    }

    public static String queryMIng(String account, String where) {
        StringBuilder builder = new StringBuilder("SELECT ");
        builder.append(TABLE_NAME).append(".").append(ID).append(" FROM ").append(TABLE_NAME);
        builder.append(where);
        builder.append(" AND ");
        builder.append(TABLE_NAME).append(".").append(STATE);
        builder.append(" = ").append(0);
        builder.append(" AND ").append(TABLE_NAME).append(".").append(SENDER);
        builder.append(" = '").append(account).append("';");
        return builder.toString();
    }

    public static String querySent(String account) {
        StringBuilder builder = new StringBuilder("SELECT ");
        builder.append(TABLE_NAME).append(".").append(ID).append(", ");
        builder.append(TABLE_NAME).append(".").append(CREATE_TIME).append(", ");
        builder.append(TABLE_NAME).append(".").append(RECEIVER).append(", ");
        builder.append(TABLE_NAME).append(".").append(TYPE);
        builder.append(" FROM ").append(TABLE_NAME).append(" WHERE ");
        builder.append(TABLE_NAME).append(".").append(SENDER);
        builder.append(" = '").append(account).append("';");
        return builder.toString();
    }

    public static String querySameFst(String where) {
        StringBuilder builder = new StringBuilder("SELECT ");
        builder.append(TABLE_NAME).append(".").append(CREATE_TIME).append(", ");
        builder.append(TABLE_NAME).append(".").append(SENDER).append(", ");
        builder.append(TABLE_NAME).append(".").append(RECEIVER).append(", ");
        builder.append(TABLE_NAME).append(".").append(TYPE).append(", ");
        builder.append(TABLE_NAME).append(".").append(STATE);
        builder.append(" FROM ").append(TABLE_NAME);
        builder.append(where);
        return builder.toString();
    }

    public static String querySaved(String where) {
        StringBuilder builder = new StringBuilder("SELECT ");
        builder.append(TABLE_NAME).append(".").append(SERVER_ID);
        builder.append(" FROM ").append(TABLE_NAME);
        builder.append(where);
        return builder.toString();
    }

    public static String queryState(String where) {
        StringBuilder builder = new StringBuilder("SELECT ");
        builder.append(TABLE_NAME).append(".").append(SERVER_ID);
        builder.append(", ").append(TABLE_NAME).append(".").append(STATE);
        builder.append(" FROM ").append(TABLE_NAME);
        builder.append(where);
        return builder.toString();
    }

    public static String queryMS(String where) {
        StringBuilder builder = MsgEntryBuilder.getAll();
        builder.append(where);
        return builder.toString();
    }

    public static String queryMIS(String where) {
        StringBuilder builder = MsgEntryBuilder.getAll();
        builder.append(where);
        return builder.toString();
    }

    public static String queryMSIS(String where) {
        StringBuilder builder = new StringBuilder("SELECT ");
        builder.append(TABLE_NAME).append(".").append(ID).append(", ");
        builder.append(TABLE_NAME).append(".").append(SERVER_ID).append(", ");
        builder.append(TABLE_NAME).append(".").append(TYPE).append(", ");
        builder.append(TABLE_NAME).append(".").append(STATE).append(", ");
        builder.append(TABLE_NAME).append(".").append(SESSION_FLAG);
        builder.append(" FROM ").append(TABLE_NAME);
        builder.append(where);
        return builder.toString();
    }

    public static String queryMax(String tag) {
        StringBuilder builder = new StringBuilder("SELECT ");
        builder.append(TABLE_NAME).append(".* ").append(" FROM ");
        builder.append(TABLE_NAME).append(" WHERE ").append(TABLE_NAME).append(".");
        builder.append(SESSION_FLAG).append(" = '").append(tag).append("' AND ");
        builder.append(TABLE_NAME).append(".").append(SORT_TIME).append(" = (SELECT MAX(");
        builder.append(TABLE_NAME).append(".").append(SORT_TIME).append(") FROM ");
        builder.append(TABLE_NAME).append(" WHERE ").append(TABLE_NAME).append(".").append(SESSION_FLAG);
        builder.append(" = '").append(tag).append("')");
        return builder.toString();
    }

    public static String queryFile(long id, ImSdkFileConstant.FileType type) {
        StringBuilder builder = new StringBuilder("SELECT ");
        builder.append(TABLE_NAME).append(".").append(ID).append(" AS ").append(JOIN_ID).append(", ");
        builder.append(TABLE_NAME).append(".").append(TYPE).append(", ");
        switch (type) {
            case IS_SHOW: {
                builder.append("file_msg").append(".* ");
                builder.append("FROM ").append(TABLE_NAME).append(" LEFT JOIN ");
                builder.append("file_msg").append(" ON ");
                builder.append(TABLE_NAME).append(".").append(ID).append(" = ");
                builder.append("file_msg").append(".").append("MSG_ID");
                builder.append(" WHERE ").append(TABLE_NAME).append(".").append(ID);
                builder.append(" = ").append(id).append(";");
                break;
            }
            case IS_HD: {
                builder.append("file_msg").append(".").append("FILE_TYPE").append(", ");
                builder.append("hd_thumb_file").append(".* ");
                builder.append("FROM ").append(TABLE_NAME).append(" LEFT JOIN ");
                builder.append("file_msg").append(" ON ");
                builder.append(TABLE_NAME).append(".").append(ID).append(" = ");
                builder.append("file_msg").append(".").append("MSG_ID");
                builder.append(" LEFT JOIN ").append("hd_thumb_file").append(" ON ");
                builder.append(TABLE_NAME).append(".").append(ID).append(" = ");
                builder.append("hd_thumb_file").append(".").append("HD_MSG_ID");
                builder.append(" WHERE ").append(TABLE_NAME).append(".").append(ID);
                builder.append(" = ").append(id).append(";");
                break;
            }
            case IS_RAW: {
                builder.append("file_msg").append(".").append("FILE_TYPE").append(", ");
                builder.append("raw_file").append(".* ");
                builder.append("FROM ").append(TABLE_NAME).append(" LEFT JOIN ");
                builder.append("file_msg").append(" ON ");
                builder.append(TABLE_NAME).append(".").append(ID).append(" = ");
                builder.append("file_msg").append(".").append("MSG_ID");
                builder.append(" LEFT JOIN ").append("raw_file").append(" ON ");
                builder.append(TABLE_NAME).append(".").append(ID).append(" = ");
                builder.append("raw_file").append(".").append("RAW_MSG_ID");
                builder.append(" WHERE ").append(TABLE_NAME).append(".").append(ID);
                builder.append(" = ").append(id).append(";");
                break;
            }
        }
        return builder.toString();
    }

    public static String queryReceipt(long id) {
        StringBuilder builder = new StringBuilder("SELECT ");
        builder.append(TABLE_NAME).append(".").append(SERVER_ID).append(", ");
        builder.append(TABLE_NAME).append(".").append(RECEIVER).append(" FROM ");
        builder.append(TABLE_NAME).append(" WHERE ").append(TABLE_NAME).append(".");
        builder.append(ID).append(" = ").append(id).append(";");
        return builder.toString();
    }

    public static String queryChange(String where) {
        StringBuilder builder = new StringBuilder("SELECT ");
        builder.append(TABLE_NAME).append(".").append(SERVER_ID).append(", ");
        builder.append(TABLE_NAME).append(".").append(RECEIVER).append(" FROM ");
        builder.append(TABLE_NAME).append(where).append(";");
        return builder.toString();
    }

    public static String queryIdByServerId(String serverId) {
        StringBuilder builder = new StringBuilder("SELECT ");
        builder.append(TABLE_NAME).append(".").append(ID).append(" FROM ");
        builder.append(TABLE_NAME).append(" WHERE ").append(TABLE_NAME).append(".");
        builder.append(SERVER_ID).append(" = ").append(serverId).append(";");
        return builder.toString();
    }

    public static String queryStrictlyCount(String tag) {
        StringBuilder builder = new StringBuilder("SELECT COUNT(");
        builder.append(TABLE_NAME).append(".").append(ID).append(") FROM ");
        builder.append(TABLE_NAME).append(" WHERE ").append(TABLE_NAME).append(".");
        builder.append(SESSION_FLAG).append(" = '").append(tag).append("'");
        builder.append(" AND (").append(TYPE).append(" & ");
        builder.append(8192).append(") = ").append(8192).append(";");
        return builder.toString();
    }
}

