/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.db.builder;

import android.text.TextUtils;
import com.xdja.imsdk.db.helper.SqlBuilder;
import java.util.Collection;
import java.util.List;

public class SessionEntryBuilder {
    public static final String TABLE_NAME = "session_entry";
    public static final String ID = "_id";
    public static final String IM_PARTNER = "IM_PARTNER";
    public static final String SESSION_TYPE = "SESSION_TYPE";
    public static final String LAST_MSG = "LAST_MSG";
    public static final String START_TIME = "START_TIME";
    public static final String LAST_TIME = "LAST_TIME";
    public static final String REMINDED = "REMINDED";
    public static final String SESSION_FLAG = "SESSION_FLAG";
    public static final String STRICTLY = "STRICTLY";
    private static final String[] ALL_COLUMNS = new String[]{"_id", "IM_PARTNER", "SESSION_TYPE", "LAST_MSG", "START_TIME", "LAST_TIME", "REMINDED", "SESSION_FLAG", "STRICTLY"};
    public static final String S_JOIN_ID = "S_JOIN_ID";
    public static final String S_TAG = "S_TAG";
    public static final String SQL_CREATE_TABLE_SESSION_ENTRY = "CREATE TABLE session_entry (_id INTEGER PRIMARY KEY AUTOINCREMENT,IM_PARTNER TEXT,SESSION_TYPE INTEGER DEFAULT 0,LAST_MSG INTEGER DEFAULT 0,START_TIME INTEGER DEFAULT 0,LAST_TIME INTEGER DEFAULT 0,REMINDED INTEGER DEFAULT 0,SESSION_FLAG TEXT UNIQUE,STRICTLY INTEGER DEFAULT 0)";
    public static final String SQL_CREATE_INDEX_ON_SESSION_TAG = "CREATE INDEX session_tag_index ON session_entry(SESSION_FLAG)";
    public static final String SQL_CREATE_INDEX_ON_LAST_MSG = "CREATE INDEX last_msg_index ON session_entry(LAST_MSG)";
    public static final String SESSION_DELETE_MSG_ON_DELETE_TRIGGER = "CREATE TRIGGER session_delete_msg_on_delete_trigger BEFORE DELETE ON session_entry BEGIN  DELETE FROM msg_entry WHERE SESSION_FLAG = old.SESSION_FLAG; END;";

    public static String insertSql() {
        return SqlBuilder.insertSql("INSERT OR IGNORE INTO  ", TABLE_NAME, ALL_COLUMNS);
    }

    public static String delSql(List<String> tags) {
        return SqlBuilder.deleteSql(TABLE_NAME, SESSION_FLAG, tags);
    }

    public static String delAll() {
        return SqlBuilder.deleteSql(TABLE_NAME, null);
    }

    public static String queryNew() {
        StringBuilder builder = SessionEntryBuilder.getJoinQuery();
        builder.append(" WHERE ").append(TABLE_NAME).append(".").append(LAST_MSG);
        builder.append(" = ").append("(SELECT MAX(").append(TABLE_NAME).append(".").append(LAST_MSG);
        builder.append(") FROM ").append(TABLE_NAME).append(") ").append(SqlBuilder.getOrder(LAST_TIME));
        return builder.toString();
    }

    public static String queryAll() {
        StringBuilder builder = SessionEntryBuilder.getJoinQuery();
        builder.append(SqlBuilder.getOrder(LAST_TIME));
        return builder.toString();
    }

    public static String querySize(String where, int size) {
        StringBuilder builder = SessionEntryBuilder.getJoinQuery();
        if (!TextUtils.isEmpty((CharSequence)where)) {
            builder.append(" WHERE ").append(where);
        }
        builder.append(SqlBuilder.getOrder(LAST_TIME));
        builder.append(SqlBuilder.getLimit(Math.abs(size)));
        return builder.toString();
    }

    public static String querySM(String tag) {
        StringBuilder builder = SessionEntryBuilder.getJoinQuery();
        builder.append(" WHERE ").append(TABLE_NAME).append(".");
        builder.append(SESSION_FLAG);
        builder.append(" = ").append("'").append(tag).append("'");
        return builder.toString();
    }

    public static String queryS(String tag) {
        StringBuilder builder = SessionEntryBuilder.getQuery();
        builder.append(" WHERE ").append(TABLE_NAME).append(".");
        builder.append(SESSION_FLAG);
        builder.append(" = ").append("'").append(tag).append("'");
        return builder.toString();
    }

    public static String queryR(String tag, boolean strictly) {
        StringBuilder builder = new StringBuilder("SELECT ");
        if (strictly) {
            builder.append(TABLE_NAME).append(".").append(STRICTLY);
        } else {
            builder.append(TABLE_NAME).append(".").append(REMINDED);
        }
        builder.append(" FROM ").append(TABLE_NAME).append(" WHERE ");
        builder.append(TABLE_NAME).append(".").append(SESSION_FLAG).append(" = ");
        builder.append("'").append(tag).append("';");
        return builder.toString();
    }

    public static String queryRSum() {
        StringBuilder builder = new StringBuilder("SELECT SUM(");
        builder.append(TABLE_NAME).append(".").append(REMINDED).append(") + SUM(");
        builder.append(TABLE_NAME).append(".").append(STRICTLY).append(") ");
        builder.append(" FROM ").append(TABLE_NAME).append(" WHERE ");
        builder.append(SESSION_FLAG).append(" <> '").append("10000_100").append("';");
        return builder.toString();
    }

    public static String queryT() {
        StringBuilder builder = new StringBuilder("SELECT ");
        builder.append(TABLE_NAME).append(".").append(SESSION_FLAG);
        builder.append(" FROM ").append(TABLE_NAME);
        return builder.toString();
    }

    public static String querySI(long msgId) {
        StringBuilder builder = SessionEntryBuilder.getQuery();
        builder.append(" WHERE ").append(TABLE_NAME).append(".");
        builder.append(SESSION_FLAG).append(" = (SELECT ");
        builder.append("msg_entry").append(".");
        builder.append(SESSION_FLAG).append(" FROM ").append("msg_entry");
        builder.append(" WHERE ").append("msg_entry").append(".");
        builder.append(ID).append(" = ").append(msgId).append(");");
        return builder.toString();
    }

    public static String queryST(Collection<?> args) {
        StringBuilder builder = SessionEntryBuilder.getJoinQuery();
        builder.append(" WHERE ").append(TABLE_NAME).append(".").append(SESSION_FLAG);
        SqlBuilder.appendColumn(builder, args);
        return builder.toString();
    }

    public static String queryIds(Collection<?> args) {
        StringBuilder builder = new StringBuilder("SELECT ");
        builder.append(TABLE_NAME).append(".").append(SESSION_FLAG).append(", ");
        builder.append(TABLE_NAME).append(".").append(LAST_MSG).append(" FROM ").append(TABLE_NAME);
        builder.append(" WHERE ").append(TABLE_NAME).append(".").append(SESSION_FLAG);
        SqlBuilder.appendColumn(builder, args);
        return builder.toString();
    }

    private static StringBuilder getJoinQuery() {
        StringBuilder builder = new StringBuilder("SELECT ");
        builder.append(TABLE_NAME).append(".").append(ID).append(" AS ").append(S_JOIN_ID).append(", ");
        builder.append(TABLE_NAME).append(".").append(SESSION_FLAG).append(" AS ").append(S_TAG).append(", ");
        builder.append("msg_entry").append(".").append(ID);
        builder.append(" AS ").append("JOIN_ID").append(", ");
        builder.append("msg_entry").append(".").append(SESSION_FLAG);
        builder.append(" AS ").append("M_TAG").append(", ");
        builder.append("file_msg").append(".").append("FILE_NAME").append(", ");
        builder.append(TABLE_NAME).append(".*, ");
        builder.append("msg_entry").append(".* ");
        builder.append(" FROM ").append(TABLE_NAME).append(" LEFT JOIN ");
        builder.append("msg_entry").append(" ON ");
        builder.append(TABLE_NAME).append(".").append(LAST_MSG).append(" = ");
        builder.append("msg_entry").append(".").append(ID);
        builder.append(" LEFT JOIN ").append("file_msg");
        builder.append(" ON ").append(TABLE_NAME).append(".").append(LAST_MSG);
        builder.append(" = ").append("file_msg").append(".").append("MSG_ID");
        return builder;
    }

    private static StringBuilder getQuery() {
        StringBuilder builder = new StringBuilder("SELECT ");
        builder.append(TABLE_NAME).append(".* ");
        builder.append(" FROM ");
        builder.append(TABLE_NAME);
        return builder;
    }

    public static String queryDesStrictly() {
        StringBuilder builder = new StringBuilder("SELECT ");
        builder.append(TABLE_NAME).append(".").append(SESSION_FLAG).append(" FROM ");
        builder.append(TABLE_NAME).append(" LEFT JOIN ").append("msg_entry");
        builder.append(" ON ").append(TABLE_NAME).append(".").append(LAST_MSG).append(" = ");
        builder.append("msg_entry").append(".").append(ID);
        builder.append(" WHERE (").append("TYPE").append(" & ");
        builder.append(8192).append(") = ").append(8192);
        builder.append(" AND ").append("msg_entry").append(".");
        builder.append("STATE").append(" = ").append(4).append(" AND (");
        builder.append("msg_entry").append(".");
        builder.append("ATTR").append(" & ").append(1);
        builder.append(") = ").append(1).append(";");
        return builder.toString();
    }
}

