/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.db.dao;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;
import com.xdja.imsdk.db.bean.RawFileDb;
import com.xdja.imsdk.db.builder.RawFileBuilder;
import com.xdja.imsdk.db.dao.AbstractDao;
import com.xdja.imsdk.db.helper.UpdateArgs;
import java.util.List;

public class RawFileDao
extends AbstractDao<RawFileDb> {
    private static RawFileDao instance;

    private RawFileDao() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RawFileDao getInstance() {
        if (instance != null) return instance;
        Class<RawFileDao> clazz = RawFileDao.class;
        synchronized (RawFileDao.class) {
            if (instance != null) return instance;
            instance = new RawFileDao();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public long insert(SQLiteDatabase db, RawFileDb entry) {
        return this.insert(db, entry, RawFileBuilder.insertSql());
    }

    public void insertBatchUpgrade(SQLiteDatabase db, List<RawFileDb> list) {
        this.insertBatchUpgrade(db, list, RawFileBuilder.insertSql());
    }

    public int deleteRaw(String sql) {
        return this.delete(sql);
    }

    public void updateR(UpdateArgs args) {
        this.update(args);
    }

    @Override
    protected RawFileDb readEntry(Cursor cursor, int offset) {
        RawFileDb entity = new RawFileDb(cursor.isNull(offset + 0) ? null : Long.valueOf(cursor.getLong(offset + 0)), cursor.isNull(offset + 1) ? null : Long.valueOf(cursor.getLong(offset + 1)), cursor.isNull(offset + 2) ? null : cursor.getString(offset + 2), cursor.isNull(offset + 3) ? null : cursor.getString(offset + 3), cursor.isNull(offset + 4) ? null : cursor.getString(offset + 4), cursor.isNull(offset + 5) ? null : Long.valueOf(cursor.getLong(offset + 5)), cursor.isNull(offset + 6) ? null : Long.valueOf(cursor.getLong(offset + 6)), cursor.isNull(offset + 7) ? null : Long.valueOf(cursor.getLong(offset + 7)), cursor.isNull(offset + 8) ? null : cursor.getString(offset + 8), cursor.isNull(offset + 9) ? null : Integer.valueOf(cursor.getInt(offset + 9)), cursor.isNull(offset + 10) ? null : cursor.getString(offset + 10));
        return entity;
    }

    @Override
    protected void bindValues(SQLiteStatement stmt, RawFileDb entity) {
        String raw_md5;
        Integer raw_state;
        String raw_fid;
        Long raw_translate_size;
        Long raw_encrypt_size;
        Long raw_file_size;
        String raw_file_name;
        String raw_encrypt_path;
        String raw_file_path;
        Long raw_msg_id;
        stmt.clearBindings();
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id.longValue());
        }
        if ((raw_msg_id = entity.getRaw_msg_id()) != null) {
            stmt.bindLong(2, raw_msg_id.longValue());
        }
        if ((raw_file_path = entity.getRaw_file_path()) != null) {
            stmt.bindString(3, raw_file_path);
        }
        if ((raw_encrypt_path = entity.getRaw_encrypt_path()) != null) {
            stmt.bindString(4, raw_encrypt_path);
        }
        if ((raw_file_name = entity.getRaw_file_name()) != null) {
            stmt.bindString(5, raw_file_name);
        }
        if ((raw_file_size = entity.getRaw_file_size()) != null) {
            stmt.bindLong(6, raw_file_size.longValue());
        }
        if ((raw_encrypt_size = entity.getRaw_encrypt_size()) != null) {
            stmt.bindLong(7, raw_encrypt_size.longValue());
        }
        if ((raw_translate_size = entity.getRaw_translate_size()) != null) {
            stmt.bindLong(8, raw_translate_size.longValue());
        }
        if ((raw_fid = entity.getRaw_fid()) != null) {
            stmt.bindString(9, raw_fid);
        }
        if ((raw_state = entity.getRaw_state()) != null) {
            stmt.bindLong(10, (long)raw_state.intValue());
        }
        if ((raw_md5 = entity.getRaw_md5()) != null) {
            stmt.bindString(11, raw_md5);
        }
    }
}

