/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.db.dao;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;
import android.text.TextUtils;
import com.xdja.imsdk.db.bean.FileMsgDb;
import com.xdja.imsdk.db.bean.MsgEntryDb;
import com.xdja.imsdk.db.bean.SessionEntryDb;
import com.xdja.imsdk.db.builder.SessionEntryBuilder;
import com.xdja.imsdk.db.dao.AbstractDao;
import com.xdja.imsdk.db.helper.OptType;
import com.xdja.imsdk.db.helper.UpdateArgs;
import com.xdja.imsdk.db.wrapper.SessionWrapper;
import com.xdja.imsdk.manager.ModelMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SessionEntryDao
extends AbstractDao<SessionEntryDb> {
    private static SessionEntryDao instance;

    private SessionEntryDao() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SessionEntryDao getInstance() {
        if (instance != null) return instance;
        Class<SessionEntryDao> clazz = SessionEntryDao.class;
        synchronized (SessionEntryDao.class) {
            if (instance != null) return instance;
            instance = new SessionEntryDao();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public long insert(SessionWrapper wrapper) {
        long rowId = 0L;
        if (wrapper == null || wrapper.getSessionEntryDb() == null) {
            return rowId;
        }
        rowId = this.insert(wrapper.getSessionEntryDb(), SessionEntryBuilder.insertSql());
        return rowId;
    }

    public void insertBatch(List<SessionWrapper> wrappers) {
        if (wrappers == null || wrappers.isEmpty()) {
            return;
        }
        List<SessionEntryDb> dbs = ModelMapper.getIns().mapSession(wrappers);
        this.insertBatch(dbs, SessionEntryBuilder.insertSql());
    }

    public void insertBatch(SQLiteDatabase db, List<SessionWrapper> wrappers) {
        if (wrappers == null || wrappers.isEmpty()) {
            return;
        }
        List<SessionEntryDb> dbs = ModelMapper.getIns().mapSession(wrappers);
        this.insertBatch(db, dbs, SessionEntryBuilder.insertSql());
    }

    public void insertBatchUpgrade(SQLiteDatabase db, List<SessionEntryDb> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        this.insertBatchUpgrade(db, list, SessionEntryBuilder.insertSql());
    }

    public int deleteS(String sql) {
        return this.delete(sql);
    }

    public void updateS(UpdateArgs args) {
        this.update(args);
    }

    public List<SessionWrapper> getSessions(String begin, int size) {
        MsgEntryDb msgEntryDb;
        SessionWrapper wrapper;
        ArrayList<SessionWrapper> result = new ArrayList<SessionWrapper>();
        StringBuilder where = new StringBuilder();
        String sql = "";
        if (TextUtils.isEmpty((CharSequence)begin)) {
            if (size < 0) {
                return result;
            }
            if (size > 0) {
                wrapper = this.getSession(SessionEntryBuilder.queryNew(), OptType.SQuery.HAVE);
                if (wrapper == null || wrapper.getMsgEntryDb() == null) {
                    return result;
                }
                msgEntryDb = wrapper.getMsgEntryDb();
                where.append("LAST_TIME").append(size > 0 ? " < ? " : " > ? ").append(msgEntryDb.getSort_time());
                sql = SessionEntryBuilder.querySize(where.toString(), size);
            }
            if (size == 0) {
                sql = SessionEntryBuilder.queryAll();
            }
        }
        if (!TextUtils.isEmpty((CharSequence)begin)) {
            wrapper = this.getSession(SessionEntryBuilder.querySM(begin), OptType.SQuery.HAVE);
            if (wrapper == null || wrapper.getMsgEntryDb() == null) {
                return result;
            }
            if (size == 0) {
                result.add(wrapper);
                return result;
            }
            msgEntryDb = wrapper.getMsgEntryDb();
            where.append("LAST_TIME").append(size > 0 ? " < ? " : " > ? ").append(msgEntryDb.getSort_time());
            sql = SessionEntryBuilder.querySize(where.toString(), size);
        }
        return this.getSessions(sql, OptType.SQuery.HAVE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<SessionWrapper> getSessions(String query, OptType.SQuery type) {
        ArrayList<SessionWrapper> entryList = new ArrayList<SessionWrapper>();
        Cursor cursor = null;
        try {
            try {
                cursor = this.query(query);
                if (type == OptType.SQuery.HAVE) {
                    while (cursor != null && cursor.moveToNext()) {
                        entryList.add(this.loadSessionCursor(cursor));
                    }
                }
                if (type != OptType.SQuery.NON) return entryList;
                while (cursor != null) {
                    if (!cursor.moveToNext()) {
                        return entryList;
                    }
                    SessionEntryDb sessionEntryDb = this.readEntry(cursor, 0);
                    SessionWrapper wrapper = new SessionWrapper(sessionEntryDb);
                    entryList.add(wrapper);
                }
                return entryList;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.closeCursor(cursor);
                return entryList;
            }
        }
        finally {
            this.closeCursor(cursor);
        }
    }

    public SessionWrapper getSession(String query, OptType.SQuery type) {
        Cursor cursor = null;
        SessionWrapper wrapper = null;
        try {
            try {
                cursor = this.query(query);
                if (type == OptType.SQuery.HAVE && cursor != null && cursor.moveToNext()) {
                    wrapper = this.loadSessionCursor(cursor);
                }
                if (type == OptType.SQuery.NON && cursor != null && cursor.moveToNext()) {
                    SessionEntryDb sessionEntryDb = this.readEntry(cursor, 0);
                    wrapper = new SessionWrapper(sessionEntryDb);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.closeCursor(cursor);
            }
        }
        finally {
            this.closeCursor(cursor);
        }
        return wrapper;
    }

    public int getRemind(String query) {
        int remindNum = 0;
        Cursor cursor = null;
        try {
            try {
                cursor = this.query(query);
                if (cursor != null && cursor.moveToNext()) {
                    remindNum = cursor.getInt(0);
                }
            }
            catch (Exception e) {
                this.closeCursor(cursor);
                return -5;
            }
        }
        finally {
            this.closeCursor(cursor);
        }
        return remindNum;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> querySessions(String query) {
        ArrayList<String> tags = new ArrayList<String>();
        Cursor cursor = null;
        try {
            try {
                cursor = this.query(query);
                while (cursor != null) {
                    if (!cursor.moveToNext()) {
                        return tags;
                    }
                    tags.add(cursor.getString(0));
                }
                return tags;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.closeCursor(cursor);
                return tags;
            }
        }
        finally {
            this.closeCursor(cursor);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> queryDesStrictlySessions(String query) {
        ArrayList<String> tags = new ArrayList<String>();
        Cursor cursor = null;
        try {
            try {
                cursor = this.query(query);
                while (cursor != null) {
                    if (!cursor.moveToNext()) {
                        return tags;
                    }
                    tags.add(cursor.getString(0));
                }
                return tags;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.closeCursor(cursor);
                return tags;
            }
        }
        finally {
            this.closeCursor(cursor);
        }
    }

    private SessionWrapper loadSessionCursor(Cursor cursor) {
        SessionWrapper wrapper = new SessionWrapper();
        SessionEntryDb s = new SessionEntryDb();
        s.setId(cursor.getLong(cursor.getColumnIndex("S_JOIN_ID")));
        s.setIm_partner(cursor.getString(cursor.getColumnIndex("IM_PARTNER")));
        s.setSession_flag(cursor.getString(cursor.getColumnIndex("S_TAG")));
        s.setSession_type(cursor.getInt(cursor.getColumnIndex("SESSION_TYPE")));
        s.setStart_time(cursor.getLong(cursor.getColumnIndex("START_TIME")));
        s.setReminded(cursor.getInt(cursor.getColumnIndex("REMINDED")));
        s.setLast_time(cursor.getLong(cursor.getColumnIndex("LAST_TIME")));
        s.setStrictly(cursor.getInt(cursor.getColumnIndex("STRICTLY")));
        s.setLast_msg(cursor.getLong(cursor.getColumnIndex("LAST_MSG")));
        MsgEntryDb m = new MsgEntryDb();
        m.setId(cursor.getLong(cursor.getColumnIndex("JOIN_ID")));
        m.setServer_id(cursor.getLong(cursor.getColumnIndex("SERVER_ID")));
        m.setCard_id(cursor.getString(cursor.getColumnIndex("CARD_ID")));
        m.setSender(cursor.getString(cursor.getColumnIndex("SENDER")));
        m.setReceiver(cursor.getString(cursor.getColumnIndex("RECEIVER")));
        m.setContent(cursor.getString(cursor.getColumnIndex("CONTENT")));
        m.setState(cursor.getInt(cursor.getColumnIndex("STATE")));
        m.setType(cursor.getInt(cursor.getColumnIndex("TYPE")));
        m.setSession_flag(cursor.getString(cursor.getColumnIndex("M_TAG")));
        m.setLife_time(cursor.getInt(cursor.getColumnIndex("LIFE_TIME")));
        m.setAttr(cursor.getInt(cursor.getColumnIndex("ATTR")));
        m.setSort_time(cursor.getLong(cursor.getColumnIndex("SORT_TIME")));
        m.setCreate_time(cursor.getLong(cursor.getColumnIndex("CREATE_TIME")));
        m.setSent_time(cursor.getLong(cursor.getColumnIndex("SENT_TIME")));
        m.setExtra_state(cursor.getInt(cursor.getColumnIndex("EXTRA_STATE")));
        FileMsgDb f = new FileMsgDb();
        f.setMsg_id(cursor.getLong(cursor.getColumnIndex("JOIN_ID")));
        f.setFile_name(cursor.getString(cursor.getColumnIndex("FILE_NAME")));
        wrapper.setSessionEntryDb(s);
        wrapper.setMsgEntryDb(m);
        wrapper.setFileMsgDb(f);
        return wrapper;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Long> querySessionIds(String query) {
        HashMap<String, Long> result = new HashMap<String, Long>();
        Cursor cursor = null;
        try {
            try {
                cursor = this.query(query);
                while (cursor != null) {
                    if (!cursor.moveToNext()) {
                        return result;
                    }
                    result.put(cursor.getString(0), cursor.getLong(1));
                }
                return result;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.closeCursor(cursor);
                return result;
            }
        }
        finally {
            this.closeCursor(cursor);
        }
    }

    @Override
    protected SessionEntryDb readEntry(Cursor cursor, int offset) {
        SessionEntryDb entry = new SessionEntryDb(cursor.isNull(offset + 0) ? null : Long.valueOf(cursor.getLong(offset + 0)), cursor.isNull(offset + 1) ? null : cursor.getString(offset + 1), cursor.isNull(offset + 2) ? null : Integer.valueOf(cursor.getInt(offset + 2)), cursor.isNull(offset + 3) ? null : Long.valueOf(cursor.getLong(offset + 3)), cursor.isNull(offset + 4) ? null : Long.valueOf(cursor.getLong(offset + 4)), cursor.isNull(offset + 5) ? null : Long.valueOf(cursor.getLong(offset + 5)), cursor.isNull(offset + 6) ? null : Integer.valueOf(cursor.getInt(offset + 6)), cursor.isNull(offset + 7) ? null : cursor.getString(offset + 7), cursor.isNull(offset + 8) ? null : Integer.valueOf(cursor.getInt(offset + 8)));
        return entry;
    }

    @Override
    protected void bindValues(SQLiteStatement stmt, SessionEntryDb entity) {
        Integer strictly;
        String session_flag;
        Integer reminded;
        Long last_time;
        Long start_time;
        Long last_msg;
        Integer session_type;
        String im_partner;
        stmt.clearBindings();
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id.longValue());
        }
        if ((im_partner = entity.getIm_partner()) != null) {
            stmt.bindString(2, im_partner);
        }
        if ((session_type = entity.getSession_type()) != null) {
            stmt.bindLong(3, (long)session_type.intValue());
        }
        if ((last_msg = entity.getLast_msg()) != null) {
            stmt.bindLong(4, last_msg.longValue());
        }
        if ((start_time = entity.getStart_time()) != null) {
            stmt.bindLong(5, start_time.longValue());
        }
        if ((last_time = entity.getLast_time()) != null) {
            stmt.bindLong(6, last_time.longValue());
        }
        if ((reminded = entity.getReminded()) != null) {
            stmt.bindLong(7, (long)reminded.intValue());
        }
        if ((session_flag = entity.getSession_flag()) != null) {
            stmt.bindString(8, session_flag);
        }
        if ((strictly = entity.getStrictly()) != null) {
            stmt.bindLong(9, (long)strictly.intValue());
        }
    }
}

