/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.http;

import android.content.Context;
import android.text.TextUtils;
import com.xdja.imsdk.constant.internal.HttpApiConstant;
import com.xdja.imsdk.http.callback.IHttpCallback;
import com.xdja.imsdk.http.config.ImRequestConfig;
import com.xdja.imsdk.http.file.FastDfsHttpClientConfig;
import com.xdja.imsdk.http.file.FileEntry;
import com.xdja.imsdk.http.file.callback.IFileDownloadCallback;
import com.xdja.imsdk.http.file.callback.IFileUploadCallback;
import com.xdja.imsdk.logger.Logger;
import com.xdja.imsdk.manager.ImSdkConfigManager;
import com.xdja.imsdk.volley.CustomRetryPolicy;
import com.xdja.imsdk.volley.error.VolleyError;
import com.xdja.imsdk.volley.request.RequestInfo;
import com.xdja.imsdk.volley.request.RequestManager;
import com.xdja.imsdk.volley.toolbox.HttpCallback;
import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

public class HttpUtils {
    private static HttpUtils instance;
    private static final Pattern UPLOAD_PATTERN;
    private FastDfsHttpClientConfig dfsHttpConfig;

    static {
        UPLOAD_PATTERN = Pattern.compile(".+\"fileid\":\"(.+?)\".+");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpUtils getInstance() {
        Class<HttpUtils> clazz = HttpUtils.class;
        synchronized (HttpUtils.class) {
            if (instance == null) {
                instance = Factory.getInstance();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void init(Context context) {
        this.dfsHttpConfig = new FastDfsHttpClientConfig(context);
        boolean isHttps = ImSdkConfigManager.getInstance().isHttps();
        int keyStoreId = ImSdkConfigManager.getInstance().getKeyStore();
        String keyStorePwd = ImSdkConfigManager.getInstance().getCert();
        RequestManager.getInstance().init(context.getApplicationContext(), isHttps, keyStoreId, keyStorePwd);
    }

    private CustomRetryPolicy getRetryPolicy(ImRequestConfig config) {
        CustomRetryPolicy policy = config.isMinTimeout() ? new CustomRetryPolicy(600000, 20000) : (config.isSecTimeout() ? new CustomRetryPolicy(30000, 30000) : new CustomRetryPolicy());
        return policy;
    }

    private CustomRetryPolicy getRetryPolicy() {
        return new CustomRetryPolicy(600000, 20000);
    }

    public void sendPostRequest(final JSONObject object, ImRequestConfig config, final IHttpCallback callback) {
        if (callback == null) {
            return;
        }
        if (object == null) {
            Logger.getLogger().e("Request url is null!!");
            callback.onFailed(50100, new JSONObject());
            return;
        }
        String baseUrl = ImSdkConfigManager.getInstance().getImServer();
        if (TextUtils.isEmpty((CharSequence)baseUrl)) {
            Logger.getLogger().e("Request url is null!!");
            callback.onFailed(50100, object);
            return;
        }
        String url = "";
        HttpApiConstant.IMRequestType type = config.getpType();
        switch (type) {
            case LOGIN: {
                url = ImSdkConfigManager.getInstance().getLoginUrl();
                break;
            }
            case LOGOUT: {
                url = ImSdkConfigManager.getInstance().getLogoutUrl();
                break;
            }
            case NORMAL: 
            case RECALL: 
            case REMIND: {
                url = ImSdkConfigManager.getInstance().getSendmsgUrl();
                break;
            }
            case PULL: {
                url = ImSdkConfigManager.getInstance().getGetmsgUrl();
                break;
            }
            case STATE: {
                url = ImSdkConfigManager.getInstance().getStateUrl();
                break;
            }
        }
        RequestInfo requestInfo = new RequestInfo();
        requestInfo.url = url;
        requestInfo.tag = config.getMsgId();
        requestInfo.retryPolicy = this.getRetryPolicy(config);
        if (config.getOptions().size() > 0) {
            requestInfo.headers = config.getOptions();
        }
        RequestManager.getInstance().post(config.getpType(), requestInfo, object, new HttpCallback(){

            @Override
            public void onStart() {
            }

            @Override
            public void onFinish() {
            }

            @Override
            public void onResult(String result) {
                try {
                    callback.onSuccess(new JSONObject(result));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    callback.onFailed(50102, object);
                }
            }

            @Override
            public void onError(VolleyError e) {
                Logger.getLogger().e("Request error:" + e);
                if (e == null) {
                    callback.onFailed(50102, object);
                } else if (e.getStatusCode() == 400 || e.getStatusCode() == 401) {
                    callback.onFailed(50101, object);
                } else {
                    callback.onFailed(e.getStatusCode(), object);
                }
            }

            @Override
            public void onNetChanged(int code, String message) {
                callback.onNetChanged(code, object);
            }

            @Override
            public void onCanceled() {
            }

            @Override
            public void onLoading(long count, long current, int percent) {
            }
        });
    }

    public void uploadStart(final FileEntry entry, final IFileUploadCallback callback) {
        if (!this.checkImFileAvailable(entry)) {
            Logger.getLogger().e("File is not available!!");
            callback.uploadFileError(50034, entry);
            return;
        }
        Logger.getLogger().d("start upload file:" + entry.getPath() + ", requestTag:" + entry.getId());
        String url = this.dfsHttpConfig.getUploadUrl();
        if (TextUtils.isEmpty((CharSequence)url)) {
            Logger.getLogger().e("File url is null!!");
            callback.uploadFileError(50034, entry);
            return;
        }
        String fileName = entry.getName();
        if (TextUtils.isEmpty((CharSequence)fileName)) {
            fileName = entry.getPath().substring(entry.getPath().lastIndexOf(File.separator));
            entry.setName(fileName);
        }
        String requestTag = String.valueOf(entry.getId());
        CustomRetryPolicy policy = this.getRetryPolicy();
        RequestManager.getInstance().sendFidRequest(url, fileName, requestTag, policy, new HttpCallback(){

            @Override
            public void onStart() {
            }

            @Override
            public void onFinish() {
            }

            @Override
            public void onResult(String result) {
                String fid = HttpUtils.this.parseGroupId(result);
                if (TextUtils.isEmpty((CharSequence)fid)) {
                    Logger.getLogger().e("request fid failed");
                    callback.uploadFileError(50030, entry);
                    return;
                }
                entry.setFid(fid);
                HttpUtils.this.uploadFile(entry, callback);
            }

            @Override
            public void onError(VolleyError e) {
                Logger.getLogger().e("Request error:" + e.getMessage());
                callback.uploadFileError(50030, entry);
            }

            @Override
            public void onNetChanged(int code, String message) {
                callback.uploadFileNetChanged(code, entry);
            }

            @Override
            public void onCanceled() {
                callback.uploadFileError(50030, entry);
            }

            @Override
            public void onLoading(long count, long current, int percent) {
            }
        });
    }

    private void uploadFile(final FileEntry entry, final IFileUploadCallback callback) {
        String url = this.dfsHttpConfig.getAppendUrl(entry.getFid());
        if (TextUtils.isEmpty((CharSequence)url)) {
            Logger.getLogger().e("Upload file url is null, so return!");
            callback.uploadFileError(50034, entry);
            return;
        }
        String requestTag = String.valueOf(entry.getId());
        CustomRetryPolicy policy = this.getRetryPolicy();
        RequestManager.getInstance().uploadFileStart(url, entry.getEncryptPath(), requestTag, policy, new HttpCallback(){

            @Override
            public void onStart() {
                callback.uploadFileStart(entry);
            }

            @Override
            public void onFinish() {
                callback.uploadFileFinish(entry);
            }

            @Override
            public void onResult(String result) {
            }

            @Override
            public void onError(VolleyError e) {
                Logger.getLogger().e("Upload file error:" + e.getMessage());
                callback.uploadFileError(50035, entry);
            }

            @Override
            public void onNetChanged(int code, String message) {
                callback.uploadFileNetChanged(code, entry);
            }

            @Override
            public void onCanceled() {
                callback.uploadFileError(50035, entry);
            }

            @Override
            public void onLoading(long count, long translateSize, int percent) {
                if (translateSize > 0L) {
                    entry.settSize(translateSize);
                    callback.uploadFileProgressUpdate(percent, entry);
                }
            }
        });
    }

    public void uploadFileResume(FileEntry entry) {
        if (entry == null) {
            Logger.getLogger().e("Upload file is null!!");
            return;
        }
        try {
            String msgId = String.valueOf(entry.getId());
            if (TextUtils.isEmpty((CharSequence)msgId)) {
                return;
            }
            RequestManager.getInstance().uploadFileResume(msgId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void uploadFilePause(FileEntry entry) {
        if (entry == null) {
            Logger.getLogger().e("Upload file is null!!");
            return;
        }
        try {
            String msgId = String.valueOf(entry.getId());
            if (TextUtils.isEmpty((CharSequence)msgId)) {
                return;
            }
            RequestManager.getInstance().uploadFilePause(msgId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void uploadFileStop(FileEntry entry) {
        if (entry == null) {
            Logger.getLogger().e("Upload file is null!!");
            return;
        }
        try {
            String msgId = String.valueOf(entry.getId());
            if (TextUtils.isEmpty((CharSequence)msgId)) {
                return;
            }
            RequestManager.getInstance().uploadFileStop(msgId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void downloadStart(FileEntry entry, IFileDownloadCallback callback) {
        this.download(entry, false, callback);
    }

    private void download(final FileEntry entry, boolean isSupportRange, final IFileDownloadCallback callback) {
        Logger.getLogger().d("ImSdk download start " + entry);
        if (!this.checkDownFileParamsAvailable(entry)) {
            callback.downloadFileError(50034, entry);
            return;
        }
        String url = this.dfsHttpConfig.getDownloadUrl(entry.getFid());
        if (TextUtils.isEmpty((CharSequence)url)) {
            Logger.getLogger().e("ERROR:File url is null.");
            callback.downloadFileError(50034, entry);
            return;
        }
        String fileSavePath = entry.getEncryptPath();
        if (TextUtils.isEmpty((CharSequence)fileSavePath)) {
            Logger.getLogger().e("ERROR: File save path is null.");
            callback.downloadFileError(50034, entry);
            return;
        }
        RequestInfo requestInfo = new RequestInfo();
        requestInfo.url = url;
        requestInfo.isSupportRange = isSupportRange;
        requestInfo.tag = String.valueOf(entry.getId());
        requestInfo.retryPolicy = this.getRetryPolicy();
        RequestManager.getInstance().downloadFile(requestInfo, fileSavePath, entry.getEncryptSize(), new HttpCallback(){

            @Override
            public void onStart() {
            }

            @Override
            public void onFinish() {
            }

            @Override
            public void onResult(String result) {
                if (entry.getSize() < entry.gettSize()) {
                    entry.setSize(entry.gettSize());
                }
                callback.downloadFileFinish(entry);
            }

            @Override
            public void onError(VolleyError e) {
                Logger.getLogger().e("onError:" + e.getMessage());
                callback.downloadFileError(50036, entry);
            }

            @Override
            public void onNetChanged(int code, String message) {
                callback.downloadNetChanged(code, entry);
            }

            @Override
            public void onCanceled() {
                callback.downloadFilePause(entry);
            }

            @Override
            public void onLoading(long count, long current, int percent) {
                entry.settSize(current);
                callback.downloadFileProgressUpdate(percent, entry);
            }
        });
    }

    public void downloadFileResume(FileEntry entry, IFileDownloadCallback callback) {
        this.download(entry, true, callback);
    }

    public void downloadFilePause(FileEntry entry) {
        if (!this.checkDownFileParamsAvailable(entry)) {
            return;
        }
        String url = this.dfsHttpConfig.getDownloadUrl(entry.getFid());
        RequestManager.getInstance().downloadFilePause(url, String.valueOf(entry.getId()));
    }

    public void downloadFileStop(FileEntry entry) {
        if (!this.checkDownFileParamsAvailable(entry)) {
            return;
        }
        String url = this.dfsHttpConfig.getDownloadUrl(entry.getFid());
        RequestManager.getInstance().downloadFileStop(url, entry.getEncryptPath());
    }

    public void cancelRequest(List<Long> msgIds) {
        for (Long msgId : msgIds) {
            RequestManager.getInstance().cancelRequest("" + msgId);
        }
    }

    public void cancelRequest(Long msgId) {
        RequestManager.getInstance().cancelRequest("" + msgId);
    }

    public void cancelAll() {
        RequestManager.getInstance().cancelAll();
    }

    private boolean checkDownFileParamsAvailable(FileEntry entry) {
        if (entry == null) {
            Logger.getLogger().e("ERROR: File entry is null.");
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)entry.getFid())) {
            Logger.getLogger().e("ERROR: File fid is null.");
            return false;
        }
        return true;
    }

    private boolean checkImFileAvailable(FileEntry entry) {
        if (entry == null || TextUtils.isEmpty((CharSequence)entry.getEncryptPath())) {
            Logger.getLogger().e("File params error!");
            return false;
        }
        File file = new File(entry.getEncryptPath());
        if (!file.exists()) {
            Logger.getLogger().e("File not exist!");
            return false;
        }
        return true;
    }

    private String parseGroupId(String response) {
        if (TextUtils.isEmpty((CharSequence)response)) {
            return null;
        }
        String res = response.replace("\\/", "/").trim();
        Matcher matcher = UPLOAD_PATTERN.matcher(res);
        if (!matcher.matches()) {
            Logger.getLogger().e("Server return data error !!!");
            return null;
        }
        if (matcher.group(1) == null || "".equals(matcher.group(1))) {
            return null;
        }
        return matcher.group(1);
    }

    private static class Factory {
        private Factory() {
        }

        static HttpUtils getInstance() {
            return new HttpUtils();
        }
    }
}

